/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.editors;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;

import de.bsvrz.buv.plugin.darstellung.actions.DarstellungActionFactory;
import de.bsvrz.buv.plugin.darstellung.actions.LetzterEmpfangenerDavZeitStempelStatus;
import de.bsvrz.buv.plugin.darstellung.actions.PositionStatus;
import de.bsvrz.buv.plugin.darstellung.actions.SelectionFilterAction;
import de.bsvrz.buv.plugin.darstellung.actions.SelectionStatus;
import de.bsvrz.buv.plugin.dobj.actions.DobjActionFactory;
import de.bsvrz.buv.plugin.dobj.editors.DobjActionBarContributor;
import de.bsvrz.buv.rw.basislib.legende.LegendeWindow;

/**
 * Erzeugt die Toolbar für den {@link AnsichtEditor}.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class AnsichtActionBarContributor extends DobjActionBarContributor {

	private static final String EXTRA_GROUP = "ExtraGroup";

	private SelectionFilterAction selectionFilter;

	@Override
	protected void buildActions() {
		super.buildActions();

		addRetargetAction(DobjActionFactory.SELECTION_RECTANGLE.create());
		addRetargetAction(DobjActionFactory.SELECTION_ELLIPSE.create());
		addRetargetAction(DobjActionFactory.SELECTION_POLYGON.create());
		addRetargetAction(DobjActionFactory.SELECTION_STRECKE.create());
		addRetargetAction(DobjActionFactory.TOGGLE_VERBINDUNGSLINIE.create());
		addRetargetAction(DobjActionFactory.TOGGLE_BAUSTELLE_GUELTIG.create());
		addRetargetAction(DobjActionFactory.TOGGLE_TOUCHED_SELECTION.create());
		addRetargetAction(DobjActionFactory.TOGGLE_SELECTION_FEEDBACK.create());
		addRetargetAction(DobjActionFactory.TOGGLE_FIX_VIEWPORT.create());

		addRetargetAction(DobjActionFactory.TOGGLE_ANTI_KOLLISIONS_ALGORITHMUS.create());

		addRetargetAction(DarstellungActionFactory.TOGGLE_OVERVIEW.create());
		addRetargetAction(DarstellungActionFactory.TOGGLE_EBENEN.create());
		addRetargetAction(DarstellungActionFactory.TOGGLE_SYNCHRONIZE_SELECTION.create());

		addRetargetAction(DarstellungActionFactory.SELECT_AUSSCHNITT.create());

		selectionFilter = new SelectionFilterAction();
		getPage().addPartListener(selectionFilter);
		addAction(selectionFilter);
	}

	@Override
	public void contributeToToolBar(final IToolBarManager toolBarManager) {
		super.contributeToToolBar(toolBarManager);

		// Selection Tools
		toolBarManager.appendToGroup(GROUP_SELECTION, getAction(DobjActionFactory.SELECTION_RECTANGLE.getCommandId()));
		toolBarManager.appendToGroup(GROUP_SELECTION, getAction(DobjActionFactory.SELECTION_ELLIPSE.getCommandId()));
		toolBarManager.appendToGroup(GROUP_SELECTION, getAction(DobjActionFactory.SELECTION_POLYGON.getCommandId()));
		toolBarManager.appendToGroup(GROUP_SELECTION, getAction(DobjActionFactory.SELECTION_STRECKE.getCommandId()));
		toolBarManager.appendToGroup(GROUP_SELECTION,
				getAction(DobjActionFactory.TOGGLE_TOUCHED_SELECTION.getCommandId()));
		toolBarManager.appendToGroup(GROUP_SELECTION,
				getAction(DobjActionFactory.TOGGLE_SELECTION_FEEDBACK.getCommandId()));
		toolBarManager.appendToGroup(GROUP_SELECTION, selectionFilter);
		toolBarManager.appendToGroup(GROUP_SELECTION,
				getAction(DarstellungActionFactory.TOGGLE_SYNCHRONIZE_SELECTION.getCommandId()));

		// Zoomtools
		toolBarManager.appendToGroup(GROUP_ZOOM, getAction(DobjActionFactory.TOGGLE_FIX_VIEWPORT.getCommandId()));
		toolBarManager.appendToGroup(GROUP_ZOOM, getAction(DarstellungActionFactory.SELECT_AUSSCHNITT.getCommandId()));

		// Allgemeine Tools
		toolBarManager.add(getAction(DobjActionFactory.TOGGLE_VERBINDUNGSLINIE.getCommandId()));

		final CommandContributionItemParameter parameter = new CommandContributionItemParameter(
				PlatformUI.getWorkbench(), null, LegendeWindow.COMMAND_ID_TOOGLE_LEGENDE_COMMAND_ID,
				CommandContributionItem.STYLE_CHECK);
		toolBarManager.add(new CommandContributionItem(parameter));

		toolBarManager.add(getAction(DarstellungActionFactory.TOGGLE_OVERVIEW.getCommandId()));
		toolBarManager.add(getAction(DarstellungActionFactory.TOGGLE_EBENEN.getCommandId()));

		toolBarManager.add(getAction(DobjActionFactory.TOGGLE_ANTI_KOLLISIONS_ALGORITHMUS.getCommandId()));

		toolBarManager.add(new Separator(EXTRA_GROUP));

		toolBarManager.appendToGroup(EXTRA_GROUP, getAction(DobjActionFactory.TOGGLE_BAUSTELLE_GUELTIG.getCommandId()));

	}

	@Override
	public void contributeToStatusLine(final IStatusLineManager statusLineManager) {
		statusLineManager.add(new PositionStatus(getPage()));
		statusLineManager.add(new SelectionStatus(getPage()));
		statusLineManager.add(new LetzterEmpfangenerDavZeitStempelStatus(getPage()));
	}

}
