/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.editparts;

import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

import de.bsvrz.buv.plugin.darstellung.editpolicies.AnsichtLayoutEditPolicy;
import de.bsvrz.buv.plugin.darstellung.figures.AnsichtFigure;
import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Ausschnitt;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.dobj.editparts.BaseGraphicalEditPart;

/**
 * Controller für die Ansicht.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class AnsichtEditPart extends BaseGraphicalEditPart<Ansicht, AnsichtFigure> {

	@Override
	protected List<?> getModelChildren() {
		return Collections.singletonList(getModel().getDarstellung());
	}

	@Override
	protected AnsichtFigure createFigure() {
		return new AnsichtFigure();
	}

	@Override
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new RootComponentEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new AnsichtLayoutEditPolicy());
	}

	@Override
	public void notifyChanged(final Notification notification) {
		final Object notifier = notification.getNotifier();
		final int type = notification.getEventType();

		if (notifier instanceof Ansicht) {
			final int featureID = notification.getFeatureID(Ansicht.class);
			switch (type) {
			case Notification.SET:
				switch (featureID) {
				case DarstellungPackage.ANSICHT__DARSTELLUNG:
					refreshChildren();
					break;
				case DarstellungPackage.ANSICHT__AUSSCHNITT:
					refreshVisuals();
					break;
				default:
				}
				break;
			default:
			}
		}
	}

	@Override
	protected void refreshVisuals() {
		final AnsichtFigure f = getFigure();
		final Ausschnitt newAusschnitt = getModel().getAusschnitt();
		if (newAusschnitt != f.getAusschnitt()) {
			f.setAusschnitt(newAusschnitt);
			gotoAusschnitt(newAusschnitt);
		}
	}

	private void gotoAusschnitt(final Ausschnitt newAusschnitt) {
		if (newAusschnitt == null) {
			getZoomManager().setZoom(1 / getZoomManager().getUIMultiplier());
			getZoomManager().getViewport().setHorizontalLocation(0);
			getZoomManager().getViewport().setVerticalLocation(0);
		} else {
			getZoomManager().setZoom(newAusschnitt.getZoomLevel());
			getZoomManager().getViewport().setHorizontalLocation(newAusschnitt.getBounds().x);
			getZoomManager().getViewport().setVerticalLocation(newAusschnitt.getBounds().y);
		}
	}

	@Override
	public void activate() {
		super.activate();
		gotoAusschnitt(getFigure().getAusschnitt());
	}
}
