/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.editparts.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

import com.bitctrl.lib.eclipse.emf.gef.editparts.tree.AdapterTreeEditPart;

import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Ausschnitt;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;

/**
 * Tree Edit Part für eine Anicht.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class AnsichtTreeEditPart extends AdapterTreeEditPart<Ansicht> {

	/**
	 * Gibt die Darstellung und den Ausschnitt der Ansicht zurück. Da der
	 * Ausschnitt optional ist, kann er in der zrückgegebenen Liste fehlen.
	 */
	@Override
	protected List<?> getModelChildren() {
		if (getParent() instanceof RootEditPart) {
			return Collections.singletonList(getModel());
		}

		final List<EObject> result = new ArrayList<>();
		result.add(getModel().getDarstellung());
		final Ausschnitt ausschnitt = getModel().getAusschnitt();
		if (ausschnitt != null) {
			result.add(ausschnitt);
		}

		return result;
	}

	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();

		if (getParent() instanceof RootEditPart) {
			installEditPolicy(EditPolicy.COMPONENT_ROLE, new RootComponentEditPolicy());
		}
	}

	@Override
	public void notifyChanged(final Notification notification) {
		final int type = notification.getEventType();
		final int featureID = notification.getFeatureID(Ansicht.class);

		switch (type) {
		case Notification.SET:
			switch (featureID) {
			case DarstellungPackage.ANSICHT__NAME:
				refreshVisuals();
				break;
			case DarstellungPackage.ANSICHT__DARSTELLUNG:
			case DarstellungPackage.ANSICHT__AUSSCHNITT:
				refreshChildren();
				break;
			}
			break;
		}

	}

}
