/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.editparts.tree;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

import com.bitctrl.lib.eclipse.emf.gef.editparts.tree.EListNodeTreeEditPart;
import com.bitctrl.lib.eclipse.emf.gef.model.EListNode;

import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Ausschnitt;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungIcons;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Edit Part Factory für die Tree Edit Parts einer {@link Ansicht} und
 * {@link Darstellung}.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DarstellungTreeEditPartFactory implements EditPartFactory {

	private static final class DarstellungEListNodeTreeEditPart extends EListNodeTreeEditPart {
		@Override
		protected Image getImage() {
			final int featureID = getModel().getFeature().getFeatureID();
			final ImageRegistry imageRegistry = DObjPlugin.getDefault().getImageRegistry();
			if (featureID == DarstellungPackage.EBENE__EBENEN || featureID == DarstellungPackage.DARSTELLUNG__EBENEN) {
				Image result = imageRegistry.get(DarstellungIcons.Ebene.name());
				if (result == null) {
					imageRegistry.put(DarstellungIcons.Ebene.name(), DarstellungIcons.Ebene.getImageDescriptor());
					result = imageRegistry.get(DarstellungIcons.Ebene.name());
				}
				return result;
			} else if (featureID == DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN) {
				Image result = imageRegistry.get(DarstellungIcons.DarstellungsSpalte.name());
				if (result == null) {
					imageRegistry.put(DarstellungIcons.DarstellungsSpalte.name(),
							DarstellungIcons.DarstellungsSpalte.getImageDescriptor());
					result = imageRegistry.get(DarstellungIcons.DarstellungsSpalte.name());
				}
				return result;

			} else if (featureID == DarstellungPackage.EBENE__EBENE_DO_TYPEN
					|| featureID == DarstellungPackage.DARSTELLUNG__DO_TYPEN) {
				Image result = imageRegistry.get(DarstellungIcons.DarstellungsObjektTyp.name());
				if (result == null) {
					imageRegistry.put(DarstellungIcons.DarstellungsObjektTyp.name(),
							DarstellungIcons.DarstellungsObjektTyp.getImageDescriptor());
					result = imageRegistry.get(DarstellungIcons.DarstellungsObjektTyp.name());
				}
				return result;
			}
			return super.getImage();
		}

		@Override
		protected String getText() {
			final int featureID = getModel().getFeature().getFeatureID();
			if (featureID == DarstellungPackage.EBENE__EBENEN || featureID == DarstellungPackage.DARSTELLUNG__EBENEN) {
				return "Ebenen";
			} else if (featureID == DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN) {
				return "Spalten";
			} else if (featureID == DarstellungPackage.EBENE__EBENE_DO_TYPEN) {
				return "DoTypen der Ebene";
			}
			return super.getText();
		}
	}

	@Override
	public EditPart createEditPart(final EditPart context, final Object model) {
		final EditPart editPart = getEditPart(model);
		editPart.setModel(model);
		return editPart;
	}

	private EditPart getEditPart(final Object model) {
		if (model instanceof Ansicht) {
			return new AnsichtTreeEditPart();
		} else if (model instanceof Ausschnitt) {
			return new AusschnittTreeEditPart();
		} else if (model instanceof Darstellung) {
			return new DarstellungTreeEditPart();
		} else if (model instanceof Ebene) {
			return new EbeneTreeEditPart();
		} else if (model instanceof DarstellungsSpalte) {
			return new DarstellungsSpalteTreeEditPart();
		} else if (model instanceof DoTyp) {
			return new DoTypTreeEditPart();
		} else if (model instanceof EListNode) {
			return new DarstellungEListNodeTreeEditPart();
		} else if (model instanceof DoModel) {
			return new DoModelTreeEditPart();
		} else if (model instanceof SystemObject) {
			return new SystemObjectTreeEditPart();
		}

		// Kein Fallback, alles andere ist ein Fehler
		String msg = "Kann kein EditPart für das Modellobjekt erzeugen: ";
		msg += model != null ? model.getClass() : "null";
		DObjPlugin.getDefault().getLog().error(msg);
		throw new IllegalArgumentException(msg);
	}

}
