/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.editparts.tree;

import java.util.Collections;
import java.util.List;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.Color;

import com.bitctrl.lib.eclipse.emf.dav.mock.MockDavObject;
import com.bitctrl.lib.eclipse.emf.gef.editparts.tree.AdapterTreeEditPart;

import de.bsvrz.buv.plugin.darstellung.editpolicies.DoModelTreeEditPolicy;
import de.bsvrz.buv.plugin.dobj.model.DoKompositum;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;

/**
 * Tree Edit Part für ein Darstellungsobjekt {@link DoModel}.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DoModelTreeEditPart extends AdapterTreeEditPart<DoModel> {

	/**
	 * Falls das Darstellungsobjekt ein Kompositum ist, werden dessen
	 * Komponenten zurückgegegen.
	 */
	@Override
	protected List<?> getModelChildren() {
		if (getModel() instanceof DoKompositum) {
			return ((DoKompositum<?>) getModel()).getKomponenten();
		}

		return Collections.emptyList();
	}

	@Override
	protected Color getForeground() {
		final DoModel so = getModel();
		if (so != null && so.getSystemObject() instanceof MockDavObject) {
			return ColorConstants.red;
		}
		return super.getForeground();
	}

	@Override
	public void notifyChanged(final Notification notification) {
		final int type = notification.getEventType();
		int featureID;

		featureID = notification.getFeatureID(DoModel.class);
		switch (type) {
		case Notification.SET:
			switch (featureID) {
			case DobjPackage.DO_MODEL__NAME:
			case DobjPackage.DO_MODEL__SYSTEM_OBJECT:
				refreshVisuals();
				break;
			}
			break;
		}

		featureID = notification.getFeatureID(DoKompositum.class);
		switch (type) {
		case Notification.ADD:
		case Notification.ADD_MANY:
		case Notification.MOVE:
		case Notification.REMOVE:
		case Notification.REMOVE_MANY:
			switch (featureID) {
			case DobjPackage.DO_KOMPOSITUM__KOMPONENTEN:
				refreshChildren();
				break;
			}
			break;
		}
	}

	@Override
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new DoModelTreeEditPolicy());
	}

}
