/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.editparts.tree;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.swt.graphics.Color;

import com.bitctrl.lib.eclipse.emf.dav.mock.MockDavObject;
import com.bitctrl.lib.eclipse.emf.gef.editparts.tree.AdapterTreeEditPart;

import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;

/**
 * Tree Edit Part für einen Darstellungsobjekttyp {@link DoTyp}.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DoTypTreeEditPart extends AdapterTreeEditPart<DoTyp> {

	@Override
	protected String getText() {
		return super.getText() + " (" + getModel().getId() + ")";
	}

	@Override
	public void notifyChanged(final Notification notification) {
		// tut tix
	}

	@Override
	protected Color getForeground() {
		final DoTyp so = getModel();
		if (so != null && so.getSystemObjectType() instanceof MockDavObject) {
			return ColorConstants.red;
		} else if (so instanceof ConfiguratedDoTyp && ((ConfiguratedDoTyp) so).getConfigurationElement() == null) {
			// das Darstellungsobjekt ist nicht installiert
			return ColorConstants.red;
		}
		return super.getForeground();
	}

}
