/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.editpolicies;

import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

import com.bitctrl.lib.eclipse.emf.gef.model.Sized;

import de.bsvrz.buv.plugin.darstellung.commands.MoveDoModelCommand;
import de.bsvrz.buv.plugin.darstellung.commands.ResizeDoModelCommand;
import de.bsvrz.buv.plugin.dobj.HotspotConverter;
import de.bsvrz.buv.plugin.dobj.model.DoModel;

/**
 * Erlaubt das Verschieben von Objekten in der Ansicht.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class AnsichtLayoutEditPolicy extends ConstrainedLayoutEditPolicy {

	private static final Dimension PREFERRED_SIZE = new Dimension(-1, -1);

	@Override
	public EditPart getTargetEditPart(final Request request) {
		return getHost();
	}

	@Override
	protected Command createAddCommand(final ChangeBoundsRequest request, final EditPart child,
			final Object constraint) {
		if (child.getModel() instanceof DoModel && constraint instanceof Rectangle) {
			final DoModel model = (DoModel) child.getModel();
			final Rectangle bounds = (Rectangle) constraint;
			final Point location = getHotspotLocation(child, bounds);

			final CompoundCommand command = new CompoundCommand("Darstellungsobjekt Verschieben und Skalieren");
			command.add(new MoveDoModelCommand(model, location));

			if (model instanceof Sized) {
				command.add(new ResizeDoModelCommand(model, bounds.getSize()));
			}

			return command.unwrap();
		}

		// Fallback
		return null;
	}

	private Point getHotspotLocation(final EditPart child, final Rectangle bounds) {
		HotspotConverter hotspotConverter = child.getAdapter(HotspotConverter.class);
		if (hotspotConverter == null) {
			hotspotConverter = Platform.getAdapterManager().getAdapter(child, HotspotConverter.class);
		}

		Point location;
		if (hotspotConverter != null) {
			location = hotspotConverter.convertViewToModel(bounds.getLocation());
		} else {
			location = bounds.getLocation();
		}
		return location;
	}

	@Override
	public Object getConstraintFor(final Point p) {
		return new Rectangle(p, PREFERRED_SIZE);
	}

	@Override
	public Object getConstraintFor(final Rectangle r) {
		return new Rectangle(r);
	}

	@Override
	protected Command getCreateCommand(final CreateRequest request) {
		return null;
	}

}
