/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.editpolicies;

import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.GroupRequest;

import de.bsvrz.buv.plugin.darstellung.commands.DeleteDoModelCommand;
import de.bsvrz.buv.plugin.darstellung.commands.MoveDoModelCommand;
import de.bsvrz.buv.plugin.dobj.HotspotConverter;
import de.bsvrz.buv.plugin.dobj.model.DoModel;

/**
 * {@link ComponentEditPolicy} die das Löschen eines {@link DoModel} steuert.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DoModelEditPolicy extends ComponentEditPolicy {

	@Override
	protected Command createDeleteCommand(final GroupRequest deleteRequest) {
		final DoModel doModel = (DoModel) getHost().getModel();
		return new DeleteDoModelCommand(doModel);
	}

	@Override
	public Command getCommand(final Request request) {
		if (REQ_ORPHAN.equals(request.getType()) && request instanceof ChangeBoundsRequest) {
			return createMoveCommand((ChangeBoundsRequest) request);
		}

		return super.getCommand(request);
	}

	private Command createMoveCommand(final ChangeBoundsRequest request) {
		final EditPart editPart = request.getEditParts().get(0);
		final DoModel model = (DoModel) editPart.getModel();
		final Point location = getHotspotLocation(editPart, request.getLocation());
		return new MoveDoModelCommand(model, location);
	}

	private Point getHotspotLocation(final EditPart child, final Point boundsLocation) {
		HotspotConverter hotspotConverter = child.getAdapter(HotspotConverter.class);
		if (hotspotConverter == null) {
			hotspotConverter = Platform.getAdapterManager().getAdapter(child, HotspotConverter.class);
		}

		Point location;
		if (hotspotConverter != null) {
			location = hotspotConverter.convertViewToModel(boundsLocation);
		} else {
			location = boundsLocation;
		}
		return location;
	}

}
