/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.darstellung.figures;

import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class DarstellungFigure extends LayeredPane {

	private Dimension darstellungSize;

	public Dimension getDarstellungSize() {
		return darstellungSize;
	}

	public void setDarstellungSize(final Dimension darstellungSize) {
		if (this.darstellungSize == darstellungSize) {
			return;
		}

		this.darstellungSize = darstellungSize;
	}

	// TODO Löschen wenn #getBounds() überschrieben bleibt.
	@Override
	public Dimension getPreferredSize(final int wHint, final int hHint) {
		if (getDarstellungSize() != null) {
			return getDarstellungSize();
		}

		return super.getPreferredSize(wHint, hHint);
	}

	@Override
	public Rectangle getBounds() {
		if (getDarstellungSize() != null) {
			return new Rectangle(bounds.x, bounds.y, darstellungSize.width, darstellungSize.height);
		}
		return super.getBounds();
	}

	@Override
	protected boolean useLocalCoordinates() {
		return true;
	}

}
