/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.figures;

import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.XYLayout;

/**
 * Eine Darstellungsspalte wird als Layer mit einem unauffälligen Rahmen
 * gezeichnet.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DarstellungsSpalteFigure extends Layer {

	private LineBorder lineBorder;

	{
		setLayoutManager(new XYLayout());

		lineBorder = new LineBorder();
		lineBorder.setColor(ColorConstants.lightGray);
		lineBorder.setStyle(Graphics.LINE_DASH);
	}

	public void showBorder() {
		setBorder(lineBorder);
	}

	public void hideBorder() {
		setBorder(null);
	}

	@Override
	protected void paintFigure(final Graphics graphics) {
		if (getBorder() instanceof AbstractBackground) {
			((AbstractBackground) getBorder()).paintBackground(this, graphics, NO_INSETS);
		}
	}

	/**
	 * Darstellungsspalten verwenden lokale Koordinaten, da sie als Layer
	 * nebeneinander anstatt wie sonst übereinander angeordnet werden.
	 */
	@Override
	protected boolean useLocalCoordinates() {
		return true;
	}

}
