/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.figures;

import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;

import com.bitctrl.lib.eclipse.draw2d.svg.SVGCache;

public class EbeneFigure extends LayeredPane {

	private Image hintergrund;
	private SVGCache svgCache;
	private double hintergrundSkalierung;
	private Point hintergrundLocation;

	public EbeneFigure() {
		setLayoutManager(new XYLayout());
	}

	public SVGCache getSvgCache() {
		return svgCache;
	}

	public void setSvgCache(final SVGCache svgCache) {
		this.svgCache = svgCache;
		if (svgCache != null) {
			setHintergrund(null);
		}
	}

	public Image getHintergrund() {
		return hintergrund;
	}

	public void setHintergrund(final Image hintergrund) {
		this.hintergrund = hintergrund;
		if (hintergrund != null) {
			setSvgCache(null);
		}
	}

	public double getHintergrundSkalierung() {
		return hintergrundSkalierung;
	}

	public void setHintergrundSkalierung(final double hintergrundSkalierung) {
		this.hintergrundSkalierung = hintergrundSkalierung;
		repaint();
	}

	public Point getHintergrundLocation() {
		return hintergrundLocation;
	}

	public void setHintergrundLocation(final Point hintergrundLocation) {
		this.hintergrundLocation = hintergrundLocation;
	}

	@Override
	protected void paintFigure(final Graphics graphics) {
		// BEGIN: Copy from super Methode
		// Auskommentiert, weil Ebene sonst nicht mehr optisch transparent
		// if (isOpaque())
		// graphics.fillRectangle(getBounds());
		if (getBorder() instanceof AbstractBackground) {
			((AbstractBackground) getBorder()).paintBackground(this, graphics, NO_INSETS);
		}
		// END: Copy from super Methode

		if (hintergrund != null) {
			final Point location;
			if (getHintergrundLocation() != null) {
				location = getHintergrundLocation();
			} else {
				location = new Point();
			}

			if (graphics instanceof ScaledGraphics) {
				graphics.scale(hintergrundSkalierung);
			}
			graphics.drawImage(hintergrund, location);
		} else if (svgCache != null && svgCache.checkContentAvailable()) {

			Image svgHintergrund = JFaceResources.getImageRegistry().get(svgCache.getURI());
			if (svgHintergrund == null) {
				svgHintergrund = svgCache.createImage(getClientArea(), graphics);
				JFaceResources.getImageRegistry().put(svgCache.getURI(), svgHintergrund);
			}
			graphics.drawImage(svgHintergrund, getClientArea().getLocation());
		}
	}

	@Override
	public Rectangle getBounds() {
		if (getParent() != null) {
			return getParent().getBounds();
		}
		return super.getBounds();
	}

}
