/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.internal;

import org.eclipse.osgi.util.NLS;

/**
 * Stellt alle übersetzbaren Texte des Plug-ins zur Verfügung.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DarstellungMessages extends NLS {

	public static String ToggleEbenen_Label;
	public static String ToggleEbenen_Tooltip;

	public static String ToggleOverview_Label;
	public static String ToggleOverview_Tooltip;

	public static String ToggleSynchronizeSelection_Label;
	public static String ToggleSynchronizeSelection_Tooltip;

	public static String SelectAusschnitt_Label;
	public static String SelectAusschnitt_Tooltip;

	/** Label für den Selektionfilter. */
	public static String SelectionFilter_Label;

	/** Tooltip für den Selektionfilter. */
	public static String SelectionFilter_Tooltip;

	static {
		NLS.initializeMessages("de.bsvrz.buv.plugin.darstellung.internal.messages", DarstellungMessages.class);
	}
}
