/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2020 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc --> A representation of the literals of the enumeration
 * '<em><b>Anzeige Verfahren</b></em>', and utility methods for working with
 * them. <!-- end-user-doc -->
 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getAnzeigeVerfahren()
 * @model
 * @generated
 */
public enum AnzeigeVerfahren implements Enumerator {
	/**
	 * The '<em><b>Verfahren I</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #VERFAHREN_I_VALUE
	 * @generated
	 * @ordered
	 */
	VERFAHREN_I(0, "VerfahrenI", "Verfahren I"),

	/**
	 * The '<em><b>Verfahren II</b></em>' literal object.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #VERFAHREN_II_VALUE
	 * @generated
	 * @ordered
	 */
	VERFAHREN_II(1, "VerfahrenII", "Verfahren II"),

	/**
	 * The '<em><b>Verfahren III</b></em>' literal object.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #VERFAHREN_III_VALUE
	 * @generated
	 * @ordered
	 */
	VERFAHREN_III(2, "VerfahrenIII", "Verfahren III");

	/**
	 * The '<em><b>Verfahren I</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Verfahren I</b></em>' literal object isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #VERFAHREN_I
	 * @model name="VerfahrenI" literal="Verfahren I"
	 * @generated
	 * @ordered
	 */
	public static final int VERFAHREN_I_VALUE = 0;

	/**
	 * The '<em><b>Verfahren II</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Verfahren II</b></em>' literal object isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #VERFAHREN_II
	 * @model name="VerfahrenII" literal="Verfahren II"
	 * @generated
	 * @ordered
	 */
	public static final int VERFAHREN_II_VALUE = 1;

	/**
	 * The '<em><b>Verfahren III</b></em>' literal value.
	 * <!-- begin-user-doc
	 * -->
	 * <p>
	 * If the meaning of '<em><b>Verfahren III</b></em>' literal object isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #VERFAHREN_III
	 * @model name="VerfahrenIII" literal="Verfahren III"
	 * @generated
	 * @ordered
	 */
	public static final int VERFAHREN_III_VALUE = 2;

	/**
	 * An array of all the '<em><b>Anzeige Verfahren</b></em>' enumerators. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private static final AnzeigeVerfahren[] VALUES_ARRAY = new AnzeigeVerfahren[] { VERFAHREN_I, VERFAHREN_II,
			VERFAHREN_III, };

	/**
	 * A public read-only list of all the '<em><b>Anzeige Verfahren</b></em>' enumerators.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<AnzeigeVerfahren> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Anzeige Verfahren</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static AnzeigeVerfahren get(String literal) {
		for (final AnzeigeVerfahren result : VALUES_ARRAY) {
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Anzeige Verfahren</b></em>' literal with the specified name.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static AnzeigeVerfahren getByName(String name) {
		for (final AnzeigeVerfahren result : VALUES_ARRAY) {
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Anzeige Verfahren</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static AnzeigeVerfahren get(int value) {
		switch (value) {
		case VERFAHREN_I_VALUE:
			return VERFAHREN_I;
		case VERFAHREN_II_VALUE:
			return VERFAHREN_II;
		case VERFAHREN_III_VALUE:
			return VERFAHREN_III;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	private AnzeigeVerfahren(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} // AnzeigeVerfahren
