/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2020 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.model;

import org.eclipse.emf.common.util.EList;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

/**
 * <!-- begin-user-doc --> A representation of the model object ' <em><b>Auto
 * Ebene</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getSystemObjectTypes <em>System Object Types</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getConfigurationAreas <em>Configuration Areas</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getSystemObjects <em>System Objects</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getMutableSets <em>Mutable Sets</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getDoTypen <em>Do Typen</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getAutoDoObjekte <em>Auto Do Objekte</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getSystemObjectsExcludes <em>System Objects Excludes</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getObjektFilter <em>Objekt Filter</em>}</li>
 * </ul>
 *
 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getAutoEbene()
 * @model
 * @generated
 */
public interface AutoEbene extends Ebene {
	/**
	 * Returns the value of the '<em><b>System Object Types</b></em>' attribute
	 * list. The list contents are of type
	 * {@link de.bsvrz.dav.daf.main.config.SystemObjectType}. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>System Object Types</em>' attribute list isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>System Object Types</em>' attribute list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getAutoEbene_SystemObjectTypes()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.dav.model.SystemObjectType"
	 * @generated
	 */
	EList<SystemObjectType> getSystemObjectTypes();

	/**
	 * Returns the value of the '<em><b>Configuration Areas</b></em>' attribute
	 * list. The list contents are of type
	 * {@link de.bsvrz.dav.daf.main.config.ConfigurationArea}. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Configuration Areas</em>' attribute list isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Configuration Areas</em>' attribute list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getAutoEbene_ConfigurationAreas()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.dav.model.ConfigurationArea"
	 * @generated
	 */
	EList<ConfigurationArea> getConfigurationAreas();

	/**
	 * Returns the value of the '<em><b>System Objects</b></em>' attribute list.
	 * The list contents are of type {@link de.bsvrz.dav.daf.main.config.SystemObject}.
	 * <!-- begin-user-doc
	 * -->
	 * <p>
	 * If the meaning of the '<em>System Objects</em>' attribute list isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>System Objects</em>' attribute list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getAutoEbene_SystemObjects()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.dav.model.SystemObject"
	 * @generated
	 */
	EList<SystemObject> getSystemObjects();

	/**
	 * Returns the value of the '<em><b>Mutable Sets</b></em>' attribute list.
	 * The list contents are of type {@link de.bsvrz.dav.daf.main.config.MutableSet}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mutable Sets</em>' attribute list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mutable Sets</em>' attribute list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getAutoEbene_MutableSets()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.dav.model.MutableSet"
	 * @generated
	 */
	EList<MutableSet> getMutableSets();

	/**
	 * Returns the value of the '<em><b>Do Typen</b></em>' reference list.
	 * The list contents are of type {@link de.bsvrz.buv.plugin.dobj.model.DoTyp}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Do Typen</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Do Typen</em>' reference list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getAutoEbene_DoTypen()
	 * @model
	 * @generated
	 */
	EList<DoTyp> getDoTypen();

	/**
	 * Returns the value of the '<em><b>Auto Do Objekte</b></em>' reference list.
	 * The list contents are of type {@link de.bsvrz.buv.plugin.dobj.model.DoModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Auto Do Objekte</em>' reference list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getAutoEbene_AutoDoObjekte()
	 * @model transient="true" changeable="false"
	 * @generated
	 */
	EList<DoModel> getAutoDoObjekte();

	/**
	 * Returns the value of the '<em><b>System Objects Excludes</b></em>' attribute list.
	 * The list contents are of type {@link de.bsvrz.dav.daf.main.config.SystemObject}.
	 * <!-- begin-user-doc
	 * -->
	 * <p>
	 * If the meaning of the '<em>System Objects Excludes</em>' attribute list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>System Objects Excludes</em>' attribute list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getAutoEbene_SystemObjectsExcludes()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.dav.model.SystemObject"
	 * @generated
	 */
	EList<SystemObject> getSystemObjectsExcludes();

	/**
	 * Returns the value of the '<em><b>Objekt Filter</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Objekt Filter</em>' attribute list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getAutoEbene_ObjektFilter()
	 * @model
	 * @generated
	 */
	EList<String> getObjektFilter();

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	boolean isAutomatischVerwaltbar(DoModel modellObjekt);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	boolean isAutomatischVerwaltet(DoModel modellObjekt);

} // AutoEbene
