/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2020 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.model;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.RGB;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.lib.eclipse.emf.gef.model.Sized;

import de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyle;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Netz;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Darstellung</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getDoTypen <em>Do Typen</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getEbenen <em>Ebenen</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getNetz <em>Netz</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getZoomSkalierung <em>Zoom Skalierung</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getZoomStufen <em>Zoom Stufen</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getProperties <em>Properties</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieFarbe <em>Verbindungslinie Farbe</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieStaerke <em>Verbindungslinie Staerke</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieStil <em>Verbindungslinie Stil</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getStoerfallverfahren <em>Stoerfallverfahren</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getAnzeigeVerfahren <em>Anzeige Verfahren</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getId <em>Id</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getZoomSuchfunktion <em>Zoom Suchfunktion</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#isLegendeAktivieren <em>Legende Aktivieren</em>}</li>
 * </ul>
 *
 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung()
 * @model abstract="true"
 * @generated
 */
public interface Darstellung extends Named, Sized {
	/**
	 * Returns the value of the '<em><b>Do Typen</b></em>' containment reference list.
	 * The list contents are of type {@link de.bsvrz.buv.plugin.dobj.model.DoTyp}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Do Typen</em>' containment reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Do Typen</em>' containment reference list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung_DoTypen()
	 * @model containment="true"
	 * @generated
	 */
	EList<DoTyp> getDoTypen();

	/**
	 * Returns the value of the '<em><b>Ebenen</b></em>' containment reference list.
	 * The list contents are of type {@link de.bsvrz.buv.plugin.darstellung.model.Ebene}.
	 * <!-- begin-user-doc
	 * -->
	 * <p>
	 * If the meaning of the '<em>Ebenen</em>' containment reference list isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ebenen</em>' containment reference list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung_Ebenen()
	 * @model containment="true" required="true"
	 * @generated
	 */
	EList<Ebene> getEbenen();

	/**
	 * Returns the value of the '<em><b>Netz</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Netz</em>' attribute isn't clear, there really
	 * should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Netz</em>' attribute.
	 * @see #setNetz(Netz)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung_Netz()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.davbitctrl.model.Netz"
	 * @generated
	 */
	Netz getNetz();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getNetz <em>Netz</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Netz</em>' attribute.
	 * @see #getNetz()
	 * @generated
	 */
	void setNetz(Netz value);

	/**
	 * Returns the value of the '<em><b>Zoom Skalierung</b></em>' attribute.
	 * The default value is <code>"1.0"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Zoom Skalierung</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Zoom Skalierung</em>' attribute.
	 * @see #setZoomSkalierung(double)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung_ZoomSkalierung()
	 * @model default="1.0"
	 * @generated
	 */
	double getZoomSkalierung();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getZoomSkalierung <em>Zoom Skalierung</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Zoom Skalierung</em>' attribute.
	 * @see #getZoomSkalierung()
	 * @generated
	 */
	void setZoomSkalierung(double value);

	/**
	 * Returns the value of the '<em><b>Zoom Stufen</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.Double}. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Zoom Stufen</em>' attribute list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Zoom Stufen</em>' attribute list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung_ZoomStufen()
	 * @model required="true"
	 * @generated
	 */
	EList<Double> getZoomStufen();

	/**
	 * Returns the value of the '<em><b>Properties</b></em>' map.
	 * The key is of type {@link K},
	 * and the value is of type {@link V},
	 * <!-- begin-user-doc
	 * -->
	 * <p>
	 * If the meaning of the '<em>Properties</em>' reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Properties</em>' map.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung_Properties()
	 * @model mapType="com.bitctrl.lib.eclipse.emf.eclipse.model.Tupel&lt;K, V&gt;"
	 * @generated
	 */
	EMap<EObject, EObject> getProperties();

	/**
	 * Returns the value of the '<em><b>Verbindungslinie Farbe</b></em>'
	 * attribute. The default value is <code>"192,192,192"</code>. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Verbindungslinie Farbe</em>' attribute isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Verbindungslinie Farbe</em>' attribute.
	 * @see #isSetVerbindungslinieFarbe()
	 * @see #unsetVerbindungslinieFarbe()
	 * @see #setVerbindungslinieFarbe(RGB)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung_VerbindungslinieFarbe()
	 * @model default="192,192,192" unsettable="true"
	 *        dataType="com.bitctrl.lib.eclipse.emf.eclipse.model.RGB"
	 * @generated
	 */
	RGB getVerbindungslinieFarbe();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieFarbe <em>Verbindungslinie Farbe</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Verbindungslinie Farbe</em>' attribute.
	 * @see #isSetVerbindungslinieFarbe()
	 * @see #unsetVerbindungslinieFarbe()
	 * @see #getVerbindungslinieFarbe()
	 * @generated
	 */
	void setVerbindungslinieFarbe(RGB value);

	/**
	 * Unsets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieFarbe <em>Verbindungslinie Farbe</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #isSetVerbindungslinieFarbe()
	 * @see #getVerbindungslinieFarbe()
	 * @see #setVerbindungslinieFarbe(RGB)
	 * @generated
	 */
	void unsetVerbindungslinieFarbe();

	/**
	 * Returns whether the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieFarbe <em>Verbindungslinie Farbe</em>}' attribute is set.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @return whether the value of the '<em>Verbindungslinie Farbe</em>' attribute is set.
	 * @see #unsetVerbindungslinieFarbe()
	 * @see #getVerbindungslinieFarbe()
	 * @see #setVerbindungslinieFarbe(RGB)
	 * @generated
	 */
	boolean isSetVerbindungslinieFarbe();

	/**
	 * Returns the value of the '<em><b>Verbindungslinie Staerke</b></em>' attribute.
	 * The default value is <code>"1"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Verbindungslinie Staerke</em>' attribute isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Verbindungslinie Staerke</em>' attribute.
	 * @see #isSetVerbindungslinieStaerke()
	 * @see #unsetVerbindungslinieStaerke()
	 * @see #setVerbindungslinieStaerke(int)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung_VerbindungslinieStaerke()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getVerbindungslinieStaerke();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieStaerke <em>Verbindungslinie Staerke</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Verbindungslinie Staerke</em>' attribute.
	 * @see #isSetVerbindungslinieStaerke()
	 * @see #unsetVerbindungslinieStaerke()
	 * @see #getVerbindungslinieStaerke()
	 * @generated
	 */
	void setVerbindungslinieStaerke(int value);

	/**
	 * Unsets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieStaerke <em>Verbindungslinie Staerke</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetVerbindungslinieStaerke()
	 * @see #getVerbindungslinieStaerke()
	 * @see #setVerbindungslinieStaerke(int)
	 * @generated
	 */
	void unsetVerbindungslinieStaerke();

	/**
	 * Returns whether the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieStaerke <em>Verbindungslinie Staerke</em>}' attribute is set.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @return whether the value of the '<em>Verbindungslinie Staerke</em>' attribute is set.
	 * @see #unsetVerbindungslinieStaerke()
	 * @see #getVerbindungslinieStaerke()
	 * @see #setVerbindungslinieStaerke(int)
	 * @generated
	 */
	boolean isSetVerbindungslinieStaerke();

	/**
	 * Returns the value of the '<em><b>Verbindungslinie Stil</b></em>'
	 * attribute. The default value is <code>"Durchgezogen"</code>. The literals
	 * are from the enumeration
	 * {@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyle}. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Verbindungslinie Stil</em>' attribute isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Verbindungslinie Stil</em>' attribute.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyle
	 * @see #isSetVerbindungslinieStil()
	 * @see #unsetVerbindungslinieStil()
	 * @see #setVerbindungslinieStil(LinienStyle)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung_VerbindungslinieStil()
	 * @model default="Durchgezogen" unsettable="true"
	 * @generated
	 */
	LinienStyle getVerbindungslinieStil();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieStil <em>Verbindungslinie Stil</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Verbindungslinie Stil</em>' attribute.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyle
	 * @see #isSetVerbindungslinieStil()
	 * @see #unsetVerbindungslinieStil()
	 * @see #getVerbindungslinieStil()
	 * @generated
	 */
	void setVerbindungslinieStil(LinienStyle value);

	/**
	 * Unsets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieStil <em>Verbindungslinie Stil</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #isSetVerbindungslinieStil()
	 * @see #getVerbindungslinieStil()
	 * @see #setVerbindungslinieStil(LinienStyle)
	 * @generated
	 */
	void unsetVerbindungslinieStil();

	/**
	 * Returns whether the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieStil <em>Verbindungslinie Stil</em>}' attribute is set.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @return whether the value of the '<em>Verbindungslinie Stil</em>' attribute is set.
	 * @see #unsetVerbindungslinieStil()
	 * @see #getVerbindungslinieStil()
	 * @see #setVerbindungslinieStil(LinienStyle)
	 * @generated
	 */
	boolean isSetVerbindungslinieStil();

	/**
	 * Returns the value of the '<em><b>Stoerfallverfahren</b></em>' attribute.
	 * The default value is <code>"unbekannt"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Stoerfallverfahren</em>' attribute isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Stoerfallverfahren</em>' attribute.
	 * @see #setStoerfallverfahren(String)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung_Stoerfallverfahren()
	 * @model default="unbekannt"
	 * @generated
	 */
	String getStoerfallverfahren();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getStoerfallverfahren <em>Stoerfallverfahren</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Stoerfallverfahren</em>' attribute.
	 * @see #getStoerfallverfahren()
	 * @generated
	 */
	void setStoerfallverfahren(String value);

	/**
	 * Returns the value of the '<em><b>Anzeige Verfahren</b></em>' attribute.
	 * The default value is <code>"Verfahren I"</code>. The literals are from
	 * the enumeration
	 * {@link de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren}. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Anzeige Verfahren</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Anzeige Verfahren</em>' attribute.
	 * @see de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren
	 * @see #setAnzeigeVerfahren(AnzeigeVerfahren)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung_AnzeigeVerfahren()
	 * @model default="Verfahren I"
	 * @generated
	 */
	AnzeigeVerfahren getAnzeigeVerfahren();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getAnzeigeVerfahren <em>Anzeige Verfahren</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Anzeige Verfahren</em>' attribute.
	 * @see de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren
	 * @see #getAnzeigeVerfahren()
	 * @generated
	 */
	void setAnzeigeVerfahren(AnzeigeVerfahren value);

	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung_Id()
	 * @model id="true"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Zoom Suchfunktion</b></em>' attribute.
	 * The default value is <code>"100"</code>.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the value of the '<em>Zoom Suchfunktion</em>' attribute.
	 * @see #setZoomSuchfunktion(int)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung_ZoomSuchfunktion()
	 * @model default="100"
	 * @generated
	 */
	int getZoomSuchfunktion();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getZoomSuchfunktion <em>Zoom Suchfunktion</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Zoom Suchfunktion</em>' attribute.
	 * @see #getZoomSuchfunktion()
	 * @generated
	 */
	void setZoomSuchfunktion(int value);

	/**
	 * Returns the value of the '<em><b>Legende Aktivieren</b></em>' attribute.
	 * The default value is <code>"true"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Legende Aktivieren</em>' attribute.
	 * @see #setLegendeAktivieren(boolean)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellung_LegendeAktivieren()
	 * @model default="true"
	 * @generated
	 */
	boolean isLegendeAktivieren();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#isLegendeAktivieren <em>Legende Aktivieren</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Legende Aktivieren</em>' attribute.
	 * @see #isLegendeAktivieren()
	 * @generated
	 */
	void setLegendeAktivieren(boolean value);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	Ebene createEbene();

} // Darstellung
