/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.darstellung.model;

import org.eclipse.emf.common.util.EList;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;

import de.bsvrz.buv.plugin.dobj.model.DoModel;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Darstellungs Spalte</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#isVisible <em>Visible</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#getWidth <em>Width</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#getDoObjekte <em>Do Objekte</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#getDarstellung <em>Darstellung</em>}</li>
 * </ul>
 *
 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellungsSpalte()
 * @model
 * @generated
 */
public interface DarstellungsSpalte extends Named {

	/**
	 * Returns the value of the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Visible</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Visible</em>' attribute.
	 * @see #setVisible(boolean)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellungsSpalte_Visible()
	 * @model
	 * @generated
	 */
	boolean isVisible();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#isVisible
	 * <em>Visible</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @param value
	 *            the new value of the '<em>Visible</em>' attribute.
	 * @see #isVisible()
	 * @generated
	 */
	void setVisible(boolean value);

	/**
	 * Returns the value of the '<em><b>Width</b></em>' attribute.
	 * The default value is <code>"250"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Width</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Width</em>' attribute.
	 * @see #setWidth(int)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellungsSpalte_Width()
	 * @model default="250"
	 * @generated
	 */
	int getWidth();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#getWidth <em>Width</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Width</em>' attribute.
	 * @see #getWidth()
	 * @generated
	 */
	void setWidth(int value);

	/**
	 * Returns the value of the '<em><b>Do Objekte</b></em>' reference list.
	 * The list contents are of type {@link de.bsvrz.buv.plugin.dobj.model.DoModel}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Do Objekte</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Do Objekte</em>' reference list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellungsSpalte_DoObjekte()
	 * @model
	 * @generated
	 */
	EList<DoModel> getDoObjekte();

	/**
	 * Returns the value of the '<em><b>Darstellung</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung#getSpalten <em>Spalten</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Darstellung</em>' container reference isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Darstellung</em>' container reference.
	 * @see #setDarstellung(StilisierteDarstellung)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getDarstellungsSpalte_Darstellung()
	 * @see de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung#getSpalten
	 * @model opposite="spalten" required="true" transient="false"
	 * @generated
	 */
	StilisierteDarstellung getDarstellung();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#getDarstellung <em>Darstellung</em>}' container reference.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Darstellung</em>' container reference.
	 * @see #getDarstellung()
	 * @generated
	 */
	void setDarstellung(StilisierteDarstellung value);

} // DarstellungsSpalte
