/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2020 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.model;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Ebene</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#isVisible <em>Visible</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#getHintergrund <em>Hintergrund</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#getHintergrundSkalierung <em>Hintergrund Skalierung</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#getHintergrundLocation <em>Hintergrund Location</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#isEditable <em>Editable</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#isAusblendbar <em>Ausblendbar</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#getEbeneDoTypen <em>Ebene Do Typen</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#getDoObjekte <em>Do Objekte</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#getEbenen <em>Ebenen</em>}</li>
 * </ul>
 *
 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getEbene()
 * @model
 * @generated
 */
public interface Ebene extends Named {

	/**
	 * Returns the value of the '<em><b>Visible</b></em>' attribute.
	 * The default value is <code>"true"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Visible</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Visible</em>' attribute.
	 * @see #setVisible(boolean)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getEbene_Visible()
	 * @model default="true"
	 * @generated
	 */
	boolean isVisible();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.darstellung.model.Ebene#isVisible
	 * <em>Visible</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @param value
	 *            the new value of the '<em>Visible</em>' attribute.
	 * @see #isVisible()
	 * @generated
	 */
	void setVisible(boolean value);

	/**
	 * Returns the value of the '<em><b>Do Objekte</b></em>' containment reference list.
	 * The list contents are of type {@link de.bsvrz.buv.plugin.dobj.model.DoModel}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Do Objekte</em>' containment reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Do Objekte</em>' containment reference list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getEbene_DoObjekte()
	 * @model containment="true"
	 * @generated
	 */
	EList<DoModel> getDoObjekte();

	/**
	 * Returns the value of the '<em><b>Hintergrund</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Hintergrund</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Hintergrund</em>' attribute.
	 * @see #setHintergrund(Bild)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getEbene_Hintergrund()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.davbitctrl.model.Bild"
	 * @generated
	 */
	Bild getHintergrund();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#getHintergrund <em>Hintergrund</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Hintergrund</em>' attribute.
	 * @see #getHintergrund()
	 * @generated
	 */
	void setHintergrund(Bild value);

	/**
	 * Returns the value of the '<em><b>Hintergrund Skalierung</b></em>' attribute.
	 * The default value is <code>"1.0"</code>.
	 * <!-- begin-user-doc
	 * -->
	 * <p>
	 * If the meaning of the '<em>Hintergrund Skalierung</em>' attribute isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Hintergrund Skalierung</em>' attribute.
	 * @see #setHintergrundSkalierung(double)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getEbene_HintergrundSkalierung()
	 * @model default="1.0"
	 * @generated
	 */
	double getHintergrundSkalierung();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#getHintergrundSkalierung <em>Hintergrund Skalierung</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Hintergrund Skalierung</em>' attribute.
	 * @see #getHintergrundSkalierung()
	 * @generated
	 */
	void setHintergrundSkalierung(double value);

	/**
	 * Returns the value of the '<em><b>Hintergrund Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Hintergrund Location</em>' attribute isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Hintergrund Location</em>' attribute.
	 * @see #setHintergrundLocation(Point)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getEbene_HintergrundLocation()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.gef.model.Point"
	 * @generated
	 */
	Point getHintergrundLocation();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#getHintergrundLocation <em>Hintergrund Location</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Hintergrund Location</em>' attribute.
	 * @see #getHintergrundLocation()
	 * @generated
	 */
	void setHintergrundLocation(Point value);

	/**
	 * Returns the value of the '<em><b>Editable</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Editable</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Editable</em>' attribute.
	 * @see #setEditable(boolean)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getEbene_Editable()
	 * @model default="false" transient="true"
	 * @generated
	 */
	boolean isEditable();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.darstellung.model.Ebene#isEditable
	 * <em>Editable</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @param value
	 *            the new value of the '<em>Editable</em>' attribute.
	 * @see #isEditable()
	 * @generated
	 */
	void setEditable(boolean value);

	/**
	 * Returns the value of the '<em><b>Ausblendbar</b></em>' attribute.
	 * The default value is <code>"true"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ausblendbar</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ausblendbar</em>' attribute.
	 * @see #setAusblendbar(boolean)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getEbene_Ausblendbar()
	 * @model default="true"
	 * @generated
	 */
	boolean isAusblendbar();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#isAusblendbar <em>Ausblendbar</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Ausblendbar</em>' attribute.
	 * @see #isAusblendbar()
	 * @generated
	 */
	void setAusblendbar(boolean value);

	/**
	 * Returns the value of the '<em><b>Ebenen</b></em>' containment reference list.
	 * The list contents are of type {@link de.bsvrz.buv.plugin.darstellung.model.Ebene}.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @return the value of the '<em>Ebenen</em>' containment reference list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getEbene_Ebenen()
	 * @model containment="true"
	 * @generated
	 */
	EList<Ebene> getEbenen();

	/**
	 * Returns the value of the '<em><b>Ebene Do Typen</b></em>' containment reference list.
	 * The list contents are of type {@link de.bsvrz.buv.plugin.dobj.model.DoTyp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ebene Do Typen</em>' containment reference list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getEbene_EbeneDoTypen()
	 * @model containment="true" keys="id"
	 * @generated
	 */
	EList<DoTyp> getEbeneDoTypen();

} // Ebene
