/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2020 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import com.bitctrl.lib.eclipse.emf.eclipse.model.impl.NamedImpl;

import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Ausschnitt;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Ansicht</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.AnsichtImpl#getAusschnitt <em>Ausschnitt</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.AnsichtImpl#getDarstellung <em>Darstellung</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.AnsichtImpl#getAusschnitte <em>Ausschnitte</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.AnsichtImpl#getId <em>Id</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AnsichtImpl extends NamedImpl implements Ansicht {
	/**
	 * The cached value of the '{@link #getAusschnitt() <em>Ausschnitt</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAusschnitt()
	 * @generated
	 * @ordered
	 */
	protected Ausschnitt ausschnitt;

	/**
	 * The cached value of the '{@link #getDarstellung() <em>Darstellung</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDarstellung()
	 * @generated
	 * @ordered
	 */
	protected Darstellung darstellung;

	/**
	 * The cached value of the '{@link #getAusschnitte() <em>Ausschnitte</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAusschnitte()
	 * @generated
	 * @ordered
	 */
	protected EList<Ausschnitt> ausschnitte;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected AnsichtImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DarstellungPackage.Literals.ANSICHT;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Ausschnitt getAusschnitt() {
		if (ausschnitt != null && ausschnitt.eIsProxy()) {
			final InternalEObject oldAusschnitt = (InternalEObject) ausschnitt;
			ausschnitt = (Ausschnitt) eResolveProxy(oldAusschnitt);
			if (ausschnitt != oldAusschnitt) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DarstellungPackage.ANSICHT__AUSSCHNITT,
							oldAusschnitt, ausschnitt));
			}
		}
		return ausschnitt;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Ausschnitt basicGetAusschnitt() {
		return ausschnitt;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAusschnitt(Ausschnitt newAusschnitt) {
		final Ausschnitt oldAusschnitt = ausschnitt;
		ausschnitt = newAusschnitt;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.ANSICHT__AUSSCHNITT, oldAusschnitt,
					ausschnitt));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Darstellung getDarstellung() {
		return darstellung;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDarstellung(Darstellung newDarstellung, NotificationChain msgs) {
		final Darstellung oldDarstellung = darstellung;
		darstellung = newDarstellung;
		if (eNotificationRequired()) {
			final ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DarstellungPackage.ANSICHT__DARSTELLUNG, oldDarstellung, newDarstellung);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDarstellung(Darstellung newDarstellung) {
		if (newDarstellung != darstellung) {
			NotificationChain msgs = null;
			if (darstellung != null)
				msgs = ((InternalEObject) darstellung).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DarstellungPackage.ANSICHT__DARSTELLUNG, null, msgs);
			if (newDarstellung != null)
				msgs = ((InternalEObject) newDarstellung).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DarstellungPackage.ANSICHT__DARSTELLUNG, null, msgs);
			msgs = basicSetDarstellung(newDarstellung, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.ANSICHT__DARSTELLUNG,
					newDarstellung, newDarstellung));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Ausschnitt> getAusschnitte() {
		if (ausschnitte == null) {
			ausschnitte = new EObjectContainmentEList<>(Ausschnitt.class, this,
					DarstellungPackage.ANSICHT__AUSSCHNITTE);
		}
		return ausschnitte;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		final String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.ANSICHT__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DarstellungPackage.ANSICHT__DARSTELLUNG:
			return basicSetDarstellung(null, msgs);
		case DarstellungPackage.ANSICHT__AUSSCHNITTE:
			return ((InternalEList<?>) getAusschnitte()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DarstellungPackage.ANSICHT__AUSSCHNITT:
			if (resolve)
				return getAusschnitt();
			return basicGetAusschnitt();
		case DarstellungPackage.ANSICHT__DARSTELLUNG:
			return getDarstellung();
		case DarstellungPackage.ANSICHT__AUSSCHNITTE:
			return getAusschnitte();
		case DarstellungPackage.ANSICHT__ID:
			return getId();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DarstellungPackage.ANSICHT__AUSSCHNITT:
			setAusschnitt((Ausschnitt) newValue);
			return;
		case DarstellungPackage.ANSICHT__DARSTELLUNG:
			setDarstellung((Darstellung) newValue);
			return;
		case DarstellungPackage.ANSICHT__AUSSCHNITTE:
			getAusschnitte().clear();
			getAusschnitte().addAll((Collection<? extends Ausschnitt>) newValue);
			return;
		case DarstellungPackage.ANSICHT__ID:
			setId((String) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DarstellungPackage.ANSICHT__AUSSCHNITT:
			setAusschnitt((Ausschnitt) null);
			return;
		case DarstellungPackage.ANSICHT__DARSTELLUNG:
			setDarstellung((Darstellung) null);
			return;
		case DarstellungPackage.ANSICHT__AUSSCHNITTE:
			getAusschnitte().clear();
			return;
		case DarstellungPackage.ANSICHT__ID:
			setId(ID_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DarstellungPackage.ANSICHT__AUSSCHNITT:
			return ausschnitt != null;
		case DarstellungPackage.ANSICHT__DARSTELLUNG:
			return darstellung != null;
		case DarstellungPackage.ANSICHT__AUSSCHNITTE:
			return ausschnitte != null && !ausschnitte.isEmpty();
		case DarstellungPackage.ANSICHT__ID:
			return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		final StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(')');
		return result.toString();
	}

} // AnsichtImpl
