/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2020 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.model.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EcoreUtil;

import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren;
import de.bsvrz.buv.plugin.darstellung.model.Ausschnitt;
import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungFactory;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.darstellung.model.util.DarstellungAdapterFactory;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!--
 * end-user-doc -->
 * @generated
 */
public class DarstellungFactoryImpl extends EFactoryImpl implements DarstellungFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public static DarstellungFactory init() {
		try {
			final DarstellungFactory theDarstellungFactory = (DarstellungFactory) EPackage.Registry.INSTANCE
					.getEFactory(DarstellungPackage.eNS_URI);
			if (theDarstellungFactory != null) {
				return theDarstellungFactory;
			}
		} catch (final Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new DarstellungFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public DarstellungFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		return switch (eClass.getClassifierID()) {
		case DarstellungPackage.ANSICHT -> createAnsicht();
		case DarstellungPackage.STILISIERTE_DARSTELLUNG -> createStilisierteDarstellung();
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG -> createMassstaeblicheDarstellung();
		case DarstellungPackage.EBENE -> createEbene();
		case DarstellungPackage.DARSTELLUNGS_SPALTE -> createDarstellungsSpalte();
		case DarstellungPackage.AUTO_EBENE -> createAutoEbene();
		case DarstellungPackage.AUSSCHNITT -> createAusschnitt();
		default -> throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		};
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		return switch (eDataType.getClassifierID()) {
		case DarstellungPackage.ANZEIGE_VERFAHREN -> createAnzeigeVerfahrenFromString(eDataType, initialValue);
		default -> throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		};
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		return switch (eDataType.getClassifierID()) {
		case DarstellungPackage.ANZEIGE_VERFAHREN -> convertAnzeigeVerfahrenToString(eDataType, instanceValue);
		default -> throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		};
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	@Override
	public Ansicht createAnsicht() {
		final AnsichtImpl ansicht = new AnsichtImpl();
		EcoreUtil.setID(ansicht, EcoreUtil.generateUUID());
		return ansicht;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated not
	 */
	@Override
	public StilisierteDarstellung createStilisierteDarstellung() {
		final StilisierteDarstellungImpl stilisierteDarstellung = new StilisierteDarstellungImpl();
		EcoreUtil.setID(stilisierteDarstellung, EcoreUtil.generateUUID());
		new DarstellungAdapterFactory().adapt(stilisierteDarstellung, Darstellung.class);
		return stilisierteDarstellung;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated not
	 */
	@Override
	public MassstaeblicheDarstellung createMassstaeblicheDarstellung() {
		final MassstaeblicheDarstellungImpl massstaeblicheDarstellung = new MassstaeblicheDarstellungImpl();
		EcoreUtil.setID(massstaeblicheDarstellung, EcoreUtil.generateUUID());
		new DarstellungAdapterFactory().adapt(massstaeblicheDarstellung, Darstellung.class);
		return massstaeblicheDarstellung;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Ebene createEbene() {
		final EbeneImpl ebene = new EbeneImpl();
		return ebene;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DarstellungsSpalte createDarstellungsSpalte() {
		final DarstellungsSpalteImpl darstellungsSpalte = new DarstellungsSpalteImpl();
		return darstellungsSpalte;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AutoEbene createAutoEbene() {
		final AutoEbeneImpl autoEbene = new AutoEbeneImpl();
		return autoEbene;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Ausschnitt createAusschnitt() {
		final AusschnittImpl ausschnitt = new AusschnittImpl();
		return ausschnitt;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public AnzeigeVerfahren createAnzeigeVerfahrenFromString(EDataType eDataType, String initialValue) {
		final AnzeigeVerfahren result = AnzeigeVerfahren.get(initialValue);
		if (result == null)
			throw new IllegalArgumentException(
					"The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String convertAnzeigeVerfahrenToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DarstellungPackage getDarstellungPackage() {
		return (DarstellungPackage) getEPackage();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static DarstellungPackage getPackage() {
		return DarstellungPackage.eINSTANCE;
	}

} // DarstellungFactoryImpl
