/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2020 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.model.impl;

import java.util.Collection;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.swt.graphics.RGB;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipseFactory;
import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;
import com.bitctrl.lib.eclipse.emf.eclipse.model.impl.NamedImpl;
import com.bitctrl.lib.eclipse.emf.eclipse.model.impl.TupelImpl;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import com.bitctrl.lib.eclipse.emf.gef.model.Sized;

import de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungFactory;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyle;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Netz;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Darstellung</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#getSize <em>Size</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#getDoTypen <em>Do Typen</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#getEbenen <em>Ebenen</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#getNetz <em>Netz</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#getZoomSkalierung <em>Zoom Skalierung</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#getZoomStufen <em>Zoom Stufen</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#getProperties <em>Properties</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#getVerbindungslinieFarbe <em>Verbindungslinie Farbe</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#getVerbindungslinieStaerke <em>Verbindungslinie Staerke</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#getVerbindungslinieStil <em>Verbindungslinie Stil</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#getStoerfallverfahren <em>Stoerfallverfahren</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#getAnzeigeVerfahren <em>Anzeige Verfahren</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#getId <em>Id</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#getZoomSuchfunktion <em>Zoom Suchfunktion</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl#isLegendeAktivieren <em>Legende Aktivieren</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class DarstellungImpl extends NamedImpl implements Darstellung {
	/**
	 * The default value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected static final Dimension SIZE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected Dimension size = SIZE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDoTypen() <em>Do Typen</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDoTypen()
	 * @generated
	 * @ordered
	 */
	protected EList<DoTyp> doTypen;

	/**
	 * The cached value of the '{@link #getEbenen() <em>Ebenen</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getEbenen()
	 * @generated
	 * @ordered
	 */
	protected EList<Ebene> ebenen;

	/**
	 * The default value of the '{@link #getNetz() <em>Netz</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getNetz()
	 * @generated
	 * @ordered
	 */
	protected static final Netz NETZ_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getNetz() <em>Netz</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getNetz()
	 * @generated
	 * @ordered
	 */
	protected Netz netz = NETZ_EDEFAULT;

	/**
	 * The default value of the '{@link #getZoomSkalierung() <em>Zoom
	 * Skalierung</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @see #getZoomSkalierung()
	 * @generated
	 * @ordered
	 */
	protected static final double ZOOM_SKALIERUNG_EDEFAULT = 1.0;

	/**
	 * The cached value of the '{@link #getZoomSkalierung() <em>Zoom
	 * Skalierung</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @see #getZoomSkalierung()
	 * @generated
	 * @ordered
	 */
	protected double zoomSkalierung = ZOOM_SKALIERUNG_EDEFAULT;

	/**
	 * The cached value of the '{@link #getZoomStufen() <em>Zoom Stufen</em>}' attribute list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getZoomStufen()
	 * @generated
	 * @ordered
	 */
	protected EList<Double> zoomStufen;

	/**
	 * The cached value of the '{@link #getProperties() <em>Properties</em>}' map.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getProperties()
	 * @generated
	 * @ordered
	 */
	protected EMap<EObject, EObject> properties;

	/**
	 * The default value of the '{@link #getVerbindungslinieFarbe() <em>Verbindungslinie Farbe</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getVerbindungslinieFarbe()
	 * @generated
	 * @ordered
	 */
	protected static final RGB VERBINDUNGSLINIE_FARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "192,192,192");

	/**
	 * The cached value of the '{@link #getVerbindungslinieFarbe() <em>Verbindungslinie Farbe</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getVerbindungslinieFarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB verbindungslinieFarbe = VERBINDUNGSLINIE_FARBE_EDEFAULT;

	/**
	 * This is true if the Verbindungslinie Farbe attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean verbindungslinieFarbeESet;

	/**
	 * The default value of the '{@link #getVerbindungslinieStaerke() <em>Verbindungslinie Staerke</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerbindungslinieStaerke()
	 * @generated
	 * @ordered
	 */
	protected static final int VERBINDUNGSLINIE_STAERKE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getVerbindungslinieStaerke() <em>Verbindungslinie Staerke</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerbindungslinieStaerke()
	 * @generated
	 * @ordered
	 */
	protected int verbindungslinieStaerke = VERBINDUNGSLINIE_STAERKE_EDEFAULT;

	/**
	 * This is true if the Verbindungslinie Staerke attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean verbindungslinieStaerkeESet;

	/**
	 * The default value of the '{@link #getVerbindungslinieStil() <em>Verbindungslinie Stil</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getVerbindungslinieStil()
	 * @generated
	 * @ordered
	 */
	protected static final LinienStyle VERBINDUNGSLINIE_STIL_EDEFAULT = LinienStyle.DURCHGEZOGEN;

	/**
	 * The cached value of the '{@link #getVerbindungslinieStil() <em>Verbindungslinie Stil</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getVerbindungslinieStil()
	 * @generated
	 * @ordered
	 */
	protected LinienStyle verbindungslinieStil = VERBINDUNGSLINIE_STIL_EDEFAULT;

	/**
	 * This is true if the Verbindungslinie Stil attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean verbindungslinieStilESet;

	/**
	 * The default value of the '{@link #getStoerfallverfahren() <em>Stoerfallverfahren</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getStoerfallverfahren()
	 * @generated
	 * @ordered
	 */
	protected static final String STOERFALLVERFAHREN_EDEFAULT = "unbekannt";

	/**
	 * The cached value of the '{@link #getStoerfallverfahren() <em>Stoerfallverfahren</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getStoerfallverfahren()
	 * @generated
	 * @ordered
	 */
	protected String stoerfallverfahren = STOERFALLVERFAHREN_EDEFAULT;

	/**
	 * The default value of the '{@link #getAnzeigeVerfahren() <em>Anzeige Verfahren</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAnzeigeVerfahren()
	 * @generated
	 * @ordered
	 */
	protected static final AnzeigeVerfahren ANZEIGE_VERFAHREN_EDEFAULT = AnzeigeVerfahren.VERFAHREN_I;

	/**
	 * The cached value of the '{@link #getAnzeigeVerfahren() <em>Anzeige Verfahren</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAnzeigeVerfahren()
	 * @generated
	 * @ordered
	 */
	protected AnzeigeVerfahren anzeigeVerfahren = ANZEIGE_VERFAHREN_EDEFAULT;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getZoomSuchfunktion() <em>Zoom
	 * Suchfunktion</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @see #getZoomSuchfunktion()
	 * @generated
	 * @ordered
	 */
	protected static final int ZOOM_SUCHFUNKTION_EDEFAULT = 100;

	/**
	 * The cached value of the '{@link #getZoomSuchfunktion() <em>Zoom
	 * Suchfunktion</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @see #getZoomSuchfunktion()
	 * @generated
	 * @ordered
	 */
	protected int zoomSuchfunktion = ZOOM_SUCHFUNKTION_EDEFAULT;

	/**
	 * The default value of the '{@link #isLegendeAktivieren() <em>Legende Aktivieren</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isLegendeAktivieren()
	 * @generated
	 * @ordered
	 */
	protected static final boolean LEGENDE_AKTIVIEREN_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isLegendeAktivieren() <em>Legende Aktivieren</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isLegendeAktivieren()
	 * @generated
	 * @ordered
	 */
	protected boolean legendeAktivieren = LEGENDE_AKTIVIEREN_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DarstellungImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DarstellungPackage.Literals.DARSTELLUNG;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Dimension getSize() {
		return size;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSize(Dimension newSize) {
		final Dimension oldSize = size;
		size = newSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.DARSTELLUNG__SIZE, oldSize, size));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DoTyp> getDoTypen() {
		if (doTypen == null) {
			doTypen = new EObjectContainmentEList<>(DoTyp.class, this, DarstellungPackage.DARSTELLUNG__DO_TYPEN);
		}
		return doTypen;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Ebene> getEbenen() {
		if (ebenen == null) {
			ebenen = new EObjectContainmentEList<>(Ebene.class, this, DarstellungPackage.DARSTELLUNG__EBENEN);
		}
		return ebenen;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Netz getNetz() {
		return netz;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setNetz(Netz newNetz) {
		final Netz oldNetz = netz;
		netz = newNetz;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.DARSTELLUNG__NETZ, oldNetz, netz));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getZoomSkalierung() {
		return zoomSkalierung;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setZoomSkalierung(double newZoomSkalierung) {
		final double oldZoomSkalierung = zoomSkalierung;
		zoomSkalierung = newZoomSkalierung;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.DARSTELLUNG__ZOOM_SKALIERUNG,
					oldZoomSkalierung, zoomSkalierung));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Double> getZoomStufen() {
		if (zoomStufen == null) {
			zoomStufen = new EDataTypeUniqueEList<>(Double.class, this,
					DarstellungPackage.DARSTELLUNG__ZOOM_STUFEN);
		}
		return zoomStufen;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	@SuppressWarnings("unchecked")
	public EMap<EObject, EObject> getProperties() {
		if (properties == null) {
			properties = new EcoreEMap<>(EclipsePackage.Literals.TUPEL, TupelImpl.class, this,
					DarstellungPackage.DARSTELLUNG__PROPERTIES);
		}
		return properties;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RGB getVerbindungslinieFarbe() {
		return verbindungslinieFarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVerbindungslinieFarbe(RGB newVerbindungslinieFarbe) {
		final RGB oldVerbindungslinieFarbe = verbindungslinieFarbe;
		verbindungslinieFarbe = newVerbindungslinieFarbe;
		final boolean oldVerbindungslinieFarbeESet = verbindungslinieFarbeESet;
		verbindungslinieFarbeESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_FARBE, oldVerbindungslinieFarbe,
					verbindungslinieFarbe, !oldVerbindungslinieFarbeESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetVerbindungslinieFarbe() {
		final RGB oldVerbindungslinieFarbe = verbindungslinieFarbe;
		final boolean oldVerbindungslinieFarbeESet = verbindungslinieFarbeESet;
		verbindungslinieFarbe = VERBINDUNGSLINIE_FARBE_EDEFAULT;
		verbindungslinieFarbeESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_FARBE, oldVerbindungslinieFarbe,
					VERBINDUNGSLINIE_FARBE_EDEFAULT, oldVerbindungslinieFarbeESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetVerbindungslinieFarbe() {
		return verbindungslinieFarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getVerbindungslinieStaerke() {
		return verbindungslinieStaerke;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVerbindungslinieStaerke(int newVerbindungslinieStaerke) {
		final int oldVerbindungslinieStaerke = verbindungslinieStaerke;
		verbindungslinieStaerke = newVerbindungslinieStaerke;
		final boolean oldVerbindungslinieStaerkeESet = verbindungslinieStaerkeESet;
		verbindungslinieStaerkeESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_STAERKE, oldVerbindungslinieStaerke,
					verbindungslinieStaerke, !oldVerbindungslinieStaerkeESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetVerbindungslinieStaerke() {
		final int oldVerbindungslinieStaerke = verbindungslinieStaerke;
		final boolean oldVerbindungslinieStaerkeESet = verbindungslinieStaerkeESet;
		verbindungslinieStaerke = VERBINDUNGSLINIE_STAERKE_EDEFAULT;
		verbindungslinieStaerkeESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_STAERKE, oldVerbindungslinieStaerke,
					VERBINDUNGSLINIE_STAERKE_EDEFAULT, oldVerbindungslinieStaerkeESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetVerbindungslinieStaerke() {
		return verbindungslinieStaerkeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LinienStyle getVerbindungslinieStil() {
		return verbindungslinieStil;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVerbindungslinieStil(LinienStyle newVerbindungslinieStil) {
		final LinienStyle oldVerbindungslinieStil = verbindungslinieStil;
		verbindungslinieStil = newVerbindungslinieStil == null ? VERBINDUNGSLINIE_STIL_EDEFAULT
				: newVerbindungslinieStil;
		final boolean oldVerbindungslinieStilESet = verbindungslinieStilESet;
		verbindungslinieStilESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_STIL,
					oldVerbindungslinieStil, verbindungslinieStil, !oldVerbindungslinieStilESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetVerbindungslinieStil() {
		final LinienStyle oldVerbindungslinieStil = verbindungslinieStil;
		final boolean oldVerbindungslinieStilESet = verbindungslinieStilESet;
		verbindungslinieStil = VERBINDUNGSLINIE_STIL_EDEFAULT;
		verbindungslinieStilESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_STIL, oldVerbindungslinieStil,
					VERBINDUNGSLINIE_STIL_EDEFAULT, oldVerbindungslinieStilESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetVerbindungslinieStil() {
		return verbindungslinieStilESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getStoerfallverfahren() {
		return stoerfallverfahren;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStoerfallverfahren(String newStoerfallverfahren) {
		final String oldStoerfallverfahren = stoerfallverfahren;
		stoerfallverfahren = newStoerfallverfahren;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.DARSTELLUNG__STOERFALLVERFAHREN,
					oldStoerfallverfahren, stoerfallverfahren));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AnzeigeVerfahren getAnzeigeVerfahren() {
		return anzeigeVerfahren;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAnzeigeVerfahren(AnzeigeVerfahren newAnzeigeVerfahren) {
		final AnzeigeVerfahren oldAnzeigeVerfahren = anzeigeVerfahren;
		anzeigeVerfahren = newAnzeigeVerfahren == null ? ANZEIGE_VERFAHREN_EDEFAULT : newAnzeigeVerfahren;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.DARSTELLUNG__ANZEIGE_VERFAHREN,
					oldAnzeigeVerfahren, anzeigeVerfahren));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		final String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.DARSTELLUNG__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getZoomSuchfunktion() {
		return zoomSuchfunktion;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setZoomSuchfunktion(int newZoomSuchfunktion) {
		final int oldZoomSuchfunktion = zoomSuchfunktion;
		zoomSuchfunktion = newZoomSuchfunktion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.DARSTELLUNG__ZOOM_SUCHFUNKTION,
					oldZoomSuchfunktion, zoomSuchfunktion));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isLegendeAktivieren() {
		return legendeAktivieren;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLegendeAktivieren(boolean newLegendeAktivieren) {
		final boolean oldLegendeAktivieren = legendeAktivieren;
		legendeAktivieren = newLegendeAktivieren;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.DARSTELLUNG__LEGENDE_AKTIVIEREN,
					oldLegendeAktivieren, legendeAktivieren));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	@Override
	public Ebene createEbene() {
		return DarstellungFactory.eINSTANCE.createEbene();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DarstellungPackage.DARSTELLUNG__DO_TYPEN:
			return ((InternalEList<?>) getDoTypen()).basicRemove(otherEnd, msgs);
		case DarstellungPackage.DARSTELLUNG__EBENEN:
			return ((InternalEList<?>) getEbenen()).basicRemove(otherEnd, msgs);
		case DarstellungPackage.DARSTELLUNG__PROPERTIES:
			return ((InternalEList<?>) getProperties()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DarstellungPackage.DARSTELLUNG__SIZE:
			return getSize();
		case DarstellungPackage.DARSTELLUNG__DO_TYPEN:
			return getDoTypen();
		case DarstellungPackage.DARSTELLUNG__EBENEN:
			return getEbenen();
		case DarstellungPackage.DARSTELLUNG__NETZ:
			return getNetz();
		case DarstellungPackage.DARSTELLUNG__ZOOM_SKALIERUNG:
			return getZoomSkalierung();
		case DarstellungPackage.DARSTELLUNG__ZOOM_STUFEN:
			return getZoomStufen();
		case DarstellungPackage.DARSTELLUNG__PROPERTIES:
			if (coreType)
				return getProperties();
			else
				return getProperties().map();
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_FARBE:
			return getVerbindungslinieFarbe();
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_STAERKE:
			return getVerbindungslinieStaerke();
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_STIL:
			return getVerbindungslinieStil();
		case DarstellungPackage.DARSTELLUNG__STOERFALLVERFAHREN:
			return getStoerfallverfahren();
		case DarstellungPackage.DARSTELLUNG__ANZEIGE_VERFAHREN:
			return getAnzeigeVerfahren();
		case DarstellungPackage.DARSTELLUNG__ID:
			return getId();
		case DarstellungPackage.DARSTELLUNG__ZOOM_SUCHFUNKTION:
			return getZoomSuchfunktion();
		case DarstellungPackage.DARSTELLUNG__LEGENDE_AKTIVIEREN:
			return isLegendeAktivieren();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DarstellungPackage.DARSTELLUNG__SIZE:
			setSize((Dimension) newValue);
			return;
		case DarstellungPackage.DARSTELLUNG__DO_TYPEN:
			getDoTypen().clear();
			getDoTypen().addAll((Collection<? extends DoTyp>) newValue);
			return;
		case DarstellungPackage.DARSTELLUNG__EBENEN:
			getEbenen().clear();
			getEbenen().addAll((Collection<? extends Ebene>) newValue);
			return;
		case DarstellungPackage.DARSTELLUNG__NETZ:
			setNetz((Netz) newValue);
			return;
		case DarstellungPackage.DARSTELLUNG__ZOOM_SKALIERUNG:
			setZoomSkalierung((Double) newValue);
			return;
		case DarstellungPackage.DARSTELLUNG__ZOOM_STUFEN:
			getZoomStufen().clear();
			getZoomStufen().addAll((Collection<? extends Double>) newValue);
			return;
		case DarstellungPackage.DARSTELLUNG__PROPERTIES:
			((EStructuralFeature.Setting) getProperties()).set(newValue);
			return;
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_FARBE:
			setVerbindungslinieFarbe((RGB) newValue);
			return;
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_STAERKE:
			setVerbindungslinieStaerke((Integer) newValue);
			return;
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_STIL:
			setVerbindungslinieStil((LinienStyle) newValue);
			return;
		case DarstellungPackage.DARSTELLUNG__STOERFALLVERFAHREN:
			setStoerfallverfahren((String) newValue);
			return;
		case DarstellungPackage.DARSTELLUNG__ANZEIGE_VERFAHREN:
			setAnzeigeVerfahren((AnzeigeVerfahren) newValue);
			return;
		case DarstellungPackage.DARSTELLUNG__ID:
			setId((String) newValue);
			return;
		case DarstellungPackage.DARSTELLUNG__ZOOM_SUCHFUNKTION:
			setZoomSuchfunktion((Integer) newValue);
			return;
		case DarstellungPackage.DARSTELLUNG__LEGENDE_AKTIVIEREN:
			setLegendeAktivieren((Boolean) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DarstellungPackage.DARSTELLUNG__SIZE:
			setSize(SIZE_EDEFAULT);
			return;
		case DarstellungPackage.DARSTELLUNG__DO_TYPEN:
			getDoTypen().clear();
			return;
		case DarstellungPackage.DARSTELLUNG__EBENEN:
			getEbenen().clear();
			return;
		case DarstellungPackage.DARSTELLUNG__NETZ:
			setNetz(NETZ_EDEFAULT);
			return;
		case DarstellungPackage.DARSTELLUNG__ZOOM_SKALIERUNG:
			setZoomSkalierung(ZOOM_SKALIERUNG_EDEFAULT);
			return;
		case DarstellungPackage.DARSTELLUNG__ZOOM_STUFEN:
			getZoomStufen().clear();
			return;
		case DarstellungPackage.DARSTELLUNG__PROPERTIES:
			getProperties().clear();
			return;
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_FARBE:
			unsetVerbindungslinieFarbe();
			return;
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_STAERKE:
			unsetVerbindungslinieStaerke();
			return;
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_STIL:
			unsetVerbindungslinieStil();
			return;
		case DarstellungPackage.DARSTELLUNG__STOERFALLVERFAHREN:
			setStoerfallverfahren(STOERFALLVERFAHREN_EDEFAULT);
			return;
		case DarstellungPackage.DARSTELLUNG__ANZEIGE_VERFAHREN:
			setAnzeigeVerfahren(ANZEIGE_VERFAHREN_EDEFAULT);
			return;
		case DarstellungPackage.DARSTELLUNG__ID:
			setId(ID_EDEFAULT);
			return;
		case DarstellungPackage.DARSTELLUNG__ZOOM_SUCHFUNKTION:
			setZoomSuchfunktion(ZOOM_SUCHFUNKTION_EDEFAULT);
			return;
		case DarstellungPackage.DARSTELLUNG__LEGENDE_AKTIVIEREN:
			setLegendeAktivieren(LEGENDE_AKTIVIEREN_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DarstellungPackage.DARSTELLUNG__SIZE:
			return SIZE_EDEFAULT == null ? size != null : !SIZE_EDEFAULT.equals(size);
		case DarstellungPackage.DARSTELLUNG__DO_TYPEN:
			return doTypen != null && !doTypen.isEmpty();
		case DarstellungPackage.DARSTELLUNG__EBENEN:
			return ebenen != null && !ebenen.isEmpty();
		case DarstellungPackage.DARSTELLUNG__NETZ:
			return NETZ_EDEFAULT == null ? netz != null : !NETZ_EDEFAULT.equals(netz);
		case DarstellungPackage.DARSTELLUNG__ZOOM_SKALIERUNG:
			return zoomSkalierung != ZOOM_SKALIERUNG_EDEFAULT;
		case DarstellungPackage.DARSTELLUNG__ZOOM_STUFEN:
			return zoomStufen != null && !zoomStufen.isEmpty();
		case DarstellungPackage.DARSTELLUNG__PROPERTIES:
			return properties != null && !properties.isEmpty();
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_FARBE:
			return isSetVerbindungslinieFarbe();
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_STAERKE:
			return isSetVerbindungslinieStaerke();
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_STIL:
			return isSetVerbindungslinieStil();
		case DarstellungPackage.DARSTELLUNG__STOERFALLVERFAHREN:
			return STOERFALLVERFAHREN_EDEFAULT == null ? stoerfallverfahren != null
					: !STOERFALLVERFAHREN_EDEFAULT.equals(stoerfallverfahren);
		case DarstellungPackage.DARSTELLUNG__ANZEIGE_VERFAHREN:
			return anzeigeVerfahren != ANZEIGE_VERFAHREN_EDEFAULT;
		case DarstellungPackage.DARSTELLUNG__ID:
			return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
		case DarstellungPackage.DARSTELLUNG__ZOOM_SUCHFUNKTION:
			return zoomSuchfunktion != ZOOM_SUCHFUNKTION_EDEFAULT;
		case DarstellungPackage.DARSTELLUNG__LEGENDE_AKTIVIEREN:
			return legendeAktivieren != LEGENDE_AKTIVIEREN_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Sized.class) {
			return switch (derivedFeatureID) {
			case DarstellungPackage.DARSTELLUNG__SIZE -> GefPackage.SIZED__SIZE;
			default -> -1;
			};
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Sized.class) {
			return switch (baseFeatureID) {
			case GefPackage.SIZED__SIZE -> DarstellungPackage.DARSTELLUNG__SIZE;
			default -> -1;
			};
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		final StringBuilder result = new StringBuilder(super.toString());
		result.append(" (size: ");
		result.append(size);
		result.append(", netz: ");
		result.append(netz);
		result.append(", zoomSkalierung: ");
		result.append(zoomSkalierung);
		result.append(", zoomStufen: ");
		result.append(zoomStufen);
		result.append(", verbindungslinieFarbe: ");
		if (verbindungslinieFarbeESet)
			result.append(verbindungslinieFarbe);
		else
			result.append("<unset>");
		result.append(", verbindungslinieStaerke: ");
		if (verbindungslinieStaerkeESet)
			result.append(verbindungslinieStaerke);
		else
			result.append("<unset>");
		result.append(", verbindungslinieStil: ");
		if (verbindungslinieStilESet)
			result.append(verbindungslinieStil);
		else
			result.append("<unset>");
		result.append(", stoerfallverfahren: ");
		result.append(stoerfallverfahren);
		result.append(", anzeigeVerfahren: ");
		result.append(anzeigeVerfahren);
		result.append(", id: ");
		result.append(id);
		result.append(", zoomSuchfunktion: ");
		result.append(zoomSuchfunktion);
		result.append(", legendeAktivieren: ");
		result.append(legendeAktivieren);
		result.append(')');
		return result.toString();
	}

} // DarstellungImpl
