/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2020 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

import com.bitctrl.lib.eclipse.emf.eclipse.model.impl.NamedImpl;

import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.dobj.model.DoModel;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Darstellungs Spalte</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungsSpalteImpl#isVisible <em>Visible</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungsSpalteImpl#getWidth <em>Width</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungsSpalteImpl#getDoObjekte <em>Do Objekte</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungsSpalteImpl#getDarstellung <em>Darstellung</em>}</li>
 * </ul>
 *
 * @generated
 */
public class DarstellungsSpalteImpl extends NamedImpl implements DarstellungsSpalte {
	/**
	 * The default value of the '{@link #isVisible() <em>Visible</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isVisible()
	 * @generated
	 * @ordered
	 */
	protected static final boolean VISIBLE_EDEFAULT = true;
	/**
	 * The cached value of the '{@link #isVisible() <em>Visible</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isVisible()
	 * @generated
	 * @ordered
	 */
	protected boolean visible = VISIBLE_EDEFAULT;
	/**
	 * The default value of the '{@link #getWidth() <em>Width</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getWidth()
	 * @generated
	 * @ordered
	 */
	protected static final int WIDTH_EDEFAULT = 250;
	/**
	 * The cached value of the '{@link #getWidth() <em>Width</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getWidth()
	 * @generated
	 * @ordered
	 */
	protected int width = WIDTH_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDoObjekte() <em>Do Objekte</em>}' reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDoObjekte()
	 * @generated
	 * @ordered
	 */
	protected EList<DoModel> doObjekte;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DarstellungsSpalteImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DarstellungPackage.Literals.DARSTELLUNGS_SPALTE;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isVisible() {
		return visible;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVisible(boolean newVisible) {
		final boolean oldVisible = visible;
		visible = newVisible;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.DARSTELLUNGS_SPALTE__VISIBLE,
					oldVisible, visible));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getWidth() {
		return width;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setWidth(int newWidth) {
		final int oldWidth = width;
		width = newWidth;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.DARSTELLUNGS_SPALTE__WIDTH,
					oldWidth, width));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DoModel> getDoObjekte() {
		if (doObjekte == null) {
			doObjekte = new EObjectResolvingEList<>(DoModel.class, this,
					DarstellungPackage.DARSTELLUNGS_SPALTE__DO_OBJEKTE);
		}
		return doObjekte;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public StilisierteDarstellung getDarstellung() {
		if (eContainerFeatureID() != DarstellungPackage.DARSTELLUNGS_SPALTE__DARSTELLUNG)
			return null;
		return (StilisierteDarstellung) eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDarstellung(StilisierteDarstellung newDarstellung, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject) newDarstellung, DarstellungPackage.DARSTELLUNGS_SPALTE__DARSTELLUNG,
				msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDarstellung(StilisierteDarstellung newDarstellung) {
		if (newDarstellung != eInternalContainer()
				|| (eContainerFeatureID() != DarstellungPackage.DARSTELLUNGS_SPALTE__DARSTELLUNG
						&& newDarstellung != null)) {
			if (EcoreUtil.isAncestor(this, newDarstellung))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newDarstellung != null)
				msgs = ((InternalEObject) newDarstellung).eInverseAdd(this,
						DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN, StilisierteDarstellung.class, msgs);
			msgs = basicSetDarstellung(newDarstellung, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.DARSTELLUNGS_SPALTE__DARSTELLUNG,
					newDarstellung, newDarstellung));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DarstellungPackage.DARSTELLUNGS_SPALTE__DARSTELLUNG:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return basicSetDarstellung((StilisierteDarstellung) otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DarstellungPackage.DARSTELLUNGS_SPALTE__DARSTELLUNG:
			return basicSetDarstellung(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
		case DarstellungPackage.DARSTELLUNGS_SPALTE__DARSTELLUNG:
			return eInternalContainer().eInverseRemove(this, DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN,
					StilisierteDarstellung.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DarstellungPackage.DARSTELLUNGS_SPALTE__VISIBLE:
			return isVisible();
		case DarstellungPackage.DARSTELLUNGS_SPALTE__WIDTH:
			return getWidth();
		case DarstellungPackage.DARSTELLUNGS_SPALTE__DO_OBJEKTE:
			return getDoObjekte();
		case DarstellungPackage.DARSTELLUNGS_SPALTE__DARSTELLUNG:
			return getDarstellung();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DarstellungPackage.DARSTELLUNGS_SPALTE__VISIBLE:
			setVisible((Boolean) newValue);
			return;
		case DarstellungPackage.DARSTELLUNGS_SPALTE__WIDTH:
			setWidth((Integer) newValue);
			return;
		case DarstellungPackage.DARSTELLUNGS_SPALTE__DO_OBJEKTE:
			getDoObjekte().clear();
			getDoObjekte().addAll((Collection<? extends DoModel>) newValue);
			return;
		case DarstellungPackage.DARSTELLUNGS_SPALTE__DARSTELLUNG:
			setDarstellung((StilisierteDarstellung) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DarstellungPackage.DARSTELLUNGS_SPALTE__VISIBLE:
			setVisible(VISIBLE_EDEFAULT);
			return;
		case DarstellungPackage.DARSTELLUNGS_SPALTE__WIDTH:
			setWidth(WIDTH_EDEFAULT);
			return;
		case DarstellungPackage.DARSTELLUNGS_SPALTE__DO_OBJEKTE:
			getDoObjekte().clear();
			return;
		case DarstellungPackage.DARSTELLUNGS_SPALTE__DARSTELLUNG:
			setDarstellung((StilisierteDarstellung) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DarstellungPackage.DARSTELLUNGS_SPALTE__VISIBLE:
			return visible != VISIBLE_EDEFAULT;
		case DarstellungPackage.DARSTELLUNGS_SPALTE__WIDTH:
			return width != WIDTH_EDEFAULT;
		case DarstellungPackage.DARSTELLUNGS_SPALTE__DO_OBJEKTE:
			return doObjekte != null && !doObjekte.isEmpty();
		case DarstellungPackage.DARSTELLUNGS_SPALTE__DARSTELLUNG:
			return getDarstellung() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		final StringBuilder result = new StringBuilder(super.toString());
		result.append(" (visible: ");
		result.append(visible);
		result.append(", width: ");
		result.append(width);
		result.append(')');
		return result.toString();
	}

} // DarstellungsSpalteImpl
