/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2020 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.model.impl;

import java.util.Collection;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import com.bitctrl.lib.eclipse.emf.eclipse.model.impl.NamedImpl;

import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Ebene</b></em>'.<!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.EbeneImpl#isVisible <em>Visible</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.EbeneImpl#getHintergrund <em>Hintergrund</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.EbeneImpl#getHintergrundSkalierung <em>Hintergrund Skalierung</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.EbeneImpl#getHintergrundLocation <em>Hintergrund Location</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.EbeneImpl#isEditable <em>Editable</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.EbeneImpl#isAusblendbar <em>Ausblendbar</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.EbeneImpl#getEbeneDoTypen <em>Ebene Do Typen</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.EbeneImpl#getDoObjekte <em>Do Objekte</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.EbeneImpl#getEbenen <em>Ebenen</em>}</li>
 * </ul>
 *
 * @generated
 */
public class EbeneImpl extends NamedImpl implements Ebene {
	/**
	 * The default value of the '{@link #isVisible() <em>Visible</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isVisible()
	 * @generated
	 * @ordered
	 */
	protected static final boolean VISIBLE_EDEFAULT = true;
	/**
	 * The cached value of the '{@link #isVisible() <em>Visible</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isVisible()
	 * @generated
	 * @ordered
	 */
	protected boolean visible = VISIBLE_EDEFAULT;
	/**
	 * The default value of the '{@link #getHintergrund() <em>Hintergrund</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getHintergrund()
	 * @generated
	 * @ordered
	 */
	protected static final Bild HINTERGRUND_EDEFAULT = null;
	/**
	 * The cached value of the '{@link #getHintergrund() <em>Hintergrund</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getHintergrund()
	 * @generated
	 * @ordered
	 */
	protected Bild hintergrund = HINTERGRUND_EDEFAULT;
	/**
	 * The default value of the '{@link #getHintergrundSkalierung() <em>Hintergrund Skalierung</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getHintergrundSkalierung()
	 * @generated
	 * @ordered
	 */
	protected static final double HINTERGRUND_SKALIERUNG_EDEFAULT = 1.0;
	/**
	 * The cached value of the '{@link #getHintergrundSkalierung() <em>Hintergrund Skalierung</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getHintergrundSkalierung()
	 * @generated
	 * @ordered
	 */
	protected double hintergrundSkalierung = HINTERGRUND_SKALIERUNG_EDEFAULT;
	/**
	 * The default value of the '{@link #getHintergrundLocation() <em>Hintergrund Location</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getHintergrundLocation()
	 * @generated
	 * @ordered
	 */
	protected static final Point HINTERGRUND_LOCATION_EDEFAULT = null;
	/**
	 * The cached value of the '{@link #getHintergrundLocation() <em>Hintergrund Location</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getHintergrundLocation()
	 * @generated
	 * @ordered
	 */
	protected Point hintergrundLocation = HINTERGRUND_LOCATION_EDEFAULT;
	/**
	 * The default value of the '{@link #isEditable() <em>Editable</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isEditable()
	 * @generated
	 * @ordered
	 */
	protected static final boolean EDITABLE_EDEFAULT = false;
	/**
	 * The cached value of the '{@link #isEditable() <em>Editable</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isEditable()
	 * @generated
	 * @ordered
	 */
	protected boolean editable = EDITABLE_EDEFAULT;
	/**
	 * The default value of the '{@link #isAusblendbar() <em>Ausblendbar</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isAusblendbar()
	 * @generated
	 * @ordered
	 */
	protected static final boolean AUSBLENDBAR_EDEFAULT = true;
	/**
	 * The cached value of the '{@link #isAusblendbar() <em>Ausblendbar</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isAusblendbar()
	 * @generated
	 * @ordered
	 */
	protected boolean ausblendbar = AUSBLENDBAR_EDEFAULT;
	/**
	 * The cached value of the '{@link #getEbeneDoTypen() <em>Ebene Do Typen</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getEbeneDoTypen()
	 * @generated
	 * @ordered
	 */
	protected EList<DoTyp> ebeneDoTypen;
	/**
	 * The cached value of the '{@link #getDoObjekte() <em>Do Objekte</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDoObjekte()
	 * @generated
	 * @ordered
	 */
	protected EList<DoModel> doObjekte;
	/**
	 * The cached value of the '{@link #getEbenen() <em>Ebenen</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getEbenen()
	 * @generated
	 * @ordered
	 */
	protected EList<Ebene> ebenen;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EbeneImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DarstellungPackage.Literals.EBENE;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isVisible() {
		return visible;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVisible(boolean newVisible) {
		final boolean oldVisible = visible;
		visible = newVisible;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.EBENE__VISIBLE, oldVisible,
					visible));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DoModel> getDoObjekte() {
		if (doObjekte == null) {
			doObjekte = new EObjectContainmentEList<>(DoModel.class, this, DarstellungPackage.EBENE__DO_OBJEKTE);
		}
		return doObjekte;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Bild getHintergrund() {
		return hintergrund;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHintergrund(Bild newHintergrund) {
		final Bild oldHintergrund = hintergrund;
		hintergrund = newHintergrund;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.EBENE__HINTERGRUND, oldHintergrund,
					hintergrund));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getHintergrundSkalierung() {
		return hintergrundSkalierung;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHintergrundSkalierung(double newHintergrundSkalierung) {
		final double oldHintergrundSkalierung = hintergrundSkalierung;
		hintergrundSkalierung = newHintergrundSkalierung;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.EBENE__HINTERGRUND_SKALIERUNG,
					oldHintergrundSkalierung, hintergrundSkalierung));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Point getHintergrundLocation() {
		return hintergrundLocation;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHintergrundLocation(Point newHintergrundLocation) {
		final Point oldHintergrundLocation = hintergrundLocation;
		hintergrundLocation = newHintergrundLocation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.EBENE__HINTERGRUND_LOCATION,
					oldHintergrundLocation, hintergrundLocation));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isEditable() {
		return editable;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEditable(boolean newEditable) {
		final boolean oldEditable = editable;
		editable = newEditable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.EBENE__EDITABLE, oldEditable,
					editable));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isAusblendbar() {
		return ausblendbar;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAusblendbar(boolean newAusblendbar) {
		final boolean oldAusblendbar = ausblendbar;
		ausblendbar = newAusblendbar;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DarstellungPackage.EBENE__AUSBLENDBAR, oldAusblendbar,
					ausblendbar));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Ebene> getEbenen() {
		if (ebenen == null) {
			ebenen = new EObjectContainmentEList<>(Ebene.class, this, DarstellungPackage.EBENE__EBENEN);
		}
		return ebenen;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DoTyp> getEbeneDoTypen() {
		if (ebeneDoTypen == null) {
			ebeneDoTypen = new EObjectContainmentEList<>(DoTyp.class, this,
					DarstellungPackage.EBENE__EBENE_DO_TYPEN);
		}
		return ebeneDoTypen;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DarstellungPackage.EBENE__EBENE_DO_TYPEN:
			return ((InternalEList<?>) getEbeneDoTypen()).basicRemove(otherEnd, msgs);
		case DarstellungPackage.EBENE__DO_OBJEKTE:
			return ((InternalEList<?>) getDoObjekte()).basicRemove(otherEnd, msgs);
		case DarstellungPackage.EBENE__EBENEN:
			return ((InternalEList<?>) getEbenen()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DarstellungPackage.EBENE__VISIBLE:
			return isVisible();
		case DarstellungPackage.EBENE__HINTERGRUND:
			return getHintergrund();
		case DarstellungPackage.EBENE__HINTERGRUND_SKALIERUNG:
			return getHintergrundSkalierung();
		case DarstellungPackage.EBENE__HINTERGRUND_LOCATION:
			return getHintergrundLocation();
		case DarstellungPackage.EBENE__EDITABLE:
			return isEditable();
		case DarstellungPackage.EBENE__AUSBLENDBAR:
			return isAusblendbar();
		case DarstellungPackage.EBENE__EBENE_DO_TYPEN:
			return getEbeneDoTypen();
		case DarstellungPackage.EBENE__DO_OBJEKTE:
			return getDoObjekte();
		case DarstellungPackage.EBENE__EBENEN:
			return getEbenen();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DarstellungPackage.EBENE__VISIBLE:
			setVisible((Boolean) newValue);
			return;
		case DarstellungPackage.EBENE__HINTERGRUND:
			setHintergrund((Bild) newValue);
			return;
		case DarstellungPackage.EBENE__HINTERGRUND_SKALIERUNG:
			setHintergrundSkalierung((Double) newValue);
			return;
		case DarstellungPackage.EBENE__HINTERGRUND_LOCATION:
			setHintergrundLocation((Point) newValue);
			return;
		case DarstellungPackage.EBENE__EDITABLE:
			setEditable((Boolean) newValue);
			return;
		case DarstellungPackage.EBENE__AUSBLENDBAR:
			setAusblendbar((Boolean) newValue);
			return;
		case DarstellungPackage.EBENE__EBENE_DO_TYPEN:
			getEbeneDoTypen().clear();
			getEbeneDoTypen().addAll((Collection<? extends DoTyp>) newValue);
			return;
		case DarstellungPackage.EBENE__DO_OBJEKTE:
			getDoObjekte().clear();
			getDoObjekte().addAll((Collection<? extends DoModel>) newValue);
			return;
		case DarstellungPackage.EBENE__EBENEN:
			getEbenen().clear();
			getEbenen().addAll((Collection<? extends Ebene>) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DarstellungPackage.EBENE__VISIBLE:
			setVisible(VISIBLE_EDEFAULT);
			return;
		case DarstellungPackage.EBENE__HINTERGRUND:
			setHintergrund(HINTERGRUND_EDEFAULT);
			return;
		case DarstellungPackage.EBENE__HINTERGRUND_SKALIERUNG:
			setHintergrundSkalierung(HINTERGRUND_SKALIERUNG_EDEFAULT);
			return;
		case DarstellungPackage.EBENE__HINTERGRUND_LOCATION:
			setHintergrundLocation(HINTERGRUND_LOCATION_EDEFAULT);
			return;
		case DarstellungPackage.EBENE__EDITABLE:
			setEditable(EDITABLE_EDEFAULT);
			return;
		case DarstellungPackage.EBENE__AUSBLENDBAR:
			setAusblendbar(AUSBLENDBAR_EDEFAULT);
			return;
		case DarstellungPackage.EBENE__EBENE_DO_TYPEN:
			getEbeneDoTypen().clear();
			return;
		case DarstellungPackage.EBENE__DO_OBJEKTE:
			getDoObjekte().clear();
			return;
		case DarstellungPackage.EBENE__EBENEN:
			getEbenen().clear();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DarstellungPackage.EBENE__VISIBLE:
			return visible != VISIBLE_EDEFAULT;
		case DarstellungPackage.EBENE__HINTERGRUND:
			return HINTERGRUND_EDEFAULT == null ? hintergrund != null : !HINTERGRUND_EDEFAULT.equals(hintergrund);
		case DarstellungPackage.EBENE__HINTERGRUND_SKALIERUNG:
			return hintergrundSkalierung != HINTERGRUND_SKALIERUNG_EDEFAULT;
		case DarstellungPackage.EBENE__HINTERGRUND_LOCATION:
			return HINTERGRUND_LOCATION_EDEFAULT == null ? hintergrundLocation != null
					: !HINTERGRUND_LOCATION_EDEFAULT.equals(hintergrundLocation);
		case DarstellungPackage.EBENE__EDITABLE:
			return editable != EDITABLE_EDEFAULT;
		case DarstellungPackage.EBENE__AUSBLENDBAR:
			return ausblendbar != AUSBLENDBAR_EDEFAULT;
		case DarstellungPackage.EBENE__EBENE_DO_TYPEN:
			return ebeneDoTypen != null && !ebeneDoTypen.isEmpty();
		case DarstellungPackage.EBENE__DO_OBJEKTE:
			return doObjekte != null && !doObjekte.isEmpty();
		case DarstellungPackage.EBENE__EBENEN:
			return ebenen != null && !ebenen.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		final StringBuilder result = new StringBuilder(super.toString());
		result.append(" (visible: ");
		result.append(visible);
		result.append(", hintergrund: ");
		result.append(hintergrund);
		result.append(", hintergrundSkalierung: ");
		result.append(hintergrundSkalierung);
		result.append(", hintergrundLocation: ");
		result.append(hintergrundLocation);
		result.append(", editable: ");
		result.append(editable);
		result.append(", ausblendbar: ");
		result.append(ausblendbar);
		result.append(')');
		return result.toString();
	}

} // EbeneImpl
