/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.darstellung.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import de.bsvrz.buv.plugin.darstellung.model.DarstellungFactory;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Massstaebliche Darstellung</b></em>'.<!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.MassstaeblicheDarstellungImpl#getMaximaleGeographischeBreite <em>Maximale Geographische Breite</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.MassstaeblicheDarstellungImpl#getMinimaleGeographischeBreite <em>Minimale Geographische Breite</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.MassstaeblicheDarstellungImpl#getMaximaleGeographischeLaenge <em>Maximale Geographische Laenge</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.MassstaeblicheDarstellungImpl#getMinimaleGeographischeLaenge <em>Minimale Geographische Laenge</em>}</li>
 * </ul>
 *
 * @generated
 */
public class MassstaeblicheDarstellungImpl extends DarstellungImpl implements MassstaeblicheDarstellung {
	/**
	 * The default value of the '{@link #getMaximaleGeographischeBreite() <em>Maximale Geographische Breite</em>}' attribute.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getMaximaleGeographischeBreite()
	 * @generated
	 * @ordered
	 */
	protected static final double MAXIMALE_GEOGRAPHISCHE_BREITE_EDEFAULT = 55.1;
	/**
	 * The cached value of the '{@link #getMaximaleGeographischeBreite() <em>Maximale Geographische Breite</em>}' attribute.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getMaximaleGeographischeBreite()
	 * @generated
	 * @ordered
	 */
	protected double maximaleGeographischeBreite = MAXIMALE_GEOGRAPHISCHE_BREITE_EDEFAULT;
	/**
	 * The default value of the '{@link #getMinimaleGeographischeBreite() <em>Minimale Geographische Breite</em>}' attribute.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getMinimaleGeographischeBreite()
	 * @generated
	 * @ordered
	 */
	protected static final double MINIMALE_GEOGRAPHISCHE_BREITE_EDEFAULT = 47.1;
	/**
	 * The cached value of the '{@link #getMinimaleGeographischeBreite() <em>Minimale Geographische Breite</em>}' attribute.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getMinimaleGeographischeBreite()
	 * @generated
	 * @ordered
	 */
	protected double minimaleGeographischeBreite = MINIMALE_GEOGRAPHISCHE_BREITE_EDEFAULT;
	/**
	 * The default value of the '{@link #getMaximaleGeographischeLaenge() <em>Maximale Geographische Laenge</em>}' attribute.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getMaximaleGeographischeLaenge()
	 * @generated
	 * @ordered
	 */
	protected static final double MAXIMALE_GEOGRAPHISCHE_LAENGE_EDEFAULT = 15.1;
	/**
	 * The cached value of the '{@link #getMaximaleGeographischeLaenge() <em>Maximale Geographische Laenge</em>}' attribute.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getMaximaleGeographischeLaenge()
	 * @generated
	 * @ordered
	 */
	protected double maximaleGeographischeLaenge = MAXIMALE_GEOGRAPHISCHE_LAENGE_EDEFAULT;
	/**
	 * The default value of the '{@link #getMinimaleGeographischeLaenge() <em>Minimale Geographische Laenge</em>}' attribute.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getMinimaleGeographischeLaenge()
	 * @generated
	 * @ordered
	 */
	protected static final double MINIMALE_GEOGRAPHISCHE_LAENGE_EDEFAULT = 5.8;
	/**
	 * The cached value of the '{@link #getMinimaleGeographischeLaenge() <em>Minimale Geographische Laenge</em>}' attribute.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getMinimaleGeographischeLaenge()
	 * @generated
	 * @ordered
	 */
	protected double minimaleGeographischeLaenge = MINIMALE_GEOGRAPHISCHE_LAENGE_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected MassstaeblicheDarstellungImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DarstellungPackage.Literals.MASSSTAEBLICHE_DARSTELLUNG;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getMaximaleGeographischeBreite() {
		return maximaleGeographischeBreite;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMaximaleGeographischeBreite(double newMaximaleGeographischeBreite) {
		double oldMaximaleGeographischeBreite = maximaleGeographischeBreite;
		maximaleGeographischeBreite = newMaximaleGeographischeBreite;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_BREITE,
					oldMaximaleGeographischeBreite, maximaleGeographischeBreite));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getMinimaleGeographischeBreite() {
		return minimaleGeographischeBreite;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMinimaleGeographischeBreite(double newMinimaleGeographischeBreite) {
		double oldMinimaleGeographischeBreite = minimaleGeographischeBreite;
		minimaleGeographischeBreite = newMinimaleGeographischeBreite;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_BREITE,
					oldMinimaleGeographischeBreite, minimaleGeographischeBreite));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getMaximaleGeographischeLaenge() {
		return maximaleGeographischeLaenge;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMaximaleGeographischeLaenge(double newMaximaleGeographischeLaenge) {
		double oldMaximaleGeographischeLaenge = maximaleGeographischeLaenge;
		maximaleGeographischeLaenge = newMaximaleGeographischeLaenge;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_LAENGE,
					oldMaximaleGeographischeLaenge, maximaleGeographischeLaenge));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getMinimaleGeographischeLaenge() {
		return minimaleGeographischeLaenge;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMinimaleGeographischeLaenge(double newMinimaleGeographischeLaenge) {
		double oldMinimaleGeographischeLaenge = minimaleGeographischeLaenge;
		minimaleGeographischeLaenge = newMinimaleGeographischeLaenge;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_LAENGE,
					oldMinimaleGeographischeLaenge, minimaleGeographischeLaenge));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public Ebene createEbene() {
		return DarstellungFactory.eINSTANCE.createAutoEbene();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_BREITE:
			return getMaximaleGeographischeBreite();
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_BREITE:
			return getMinimaleGeographischeBreite();
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_LAENGE:
			return getMaximaleGeographischeLaenge();
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_LAENGE:
			return getMinimaleGeographischeLaenge();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_BREITE:
			setMaximaleGeographischeBreite((Double) newValue);
			return;
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_BREITE:
			setMinimaleGeographischeBreite((Double) newValue);
			return;
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_LAENGE:
			setMaximaleGeographischeLaenge((Double) newValue);
			return;
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_LAENGE:
			setMinimaleGeographischeLaenge((Double) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_BREITE:
			setMaximaleGeographischeBreite(MAXIMALE_GEOGRAPHISCHE_BREITE_EDEFAULT);
			return;
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_BREITE:
			setMinimaleGeographischeBreite(MINIMALE_GEOGRAPHISCHE_BREITE_EDEFAULT);
			return;
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_LAENGE:
			setMaximaleGeographischeLaenge(MAXIMALE_GEOGRAPHISCHE_LAENGE_EDEFAULT);
			return;
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_LAENGE:
			setMinimaleGeographischeLaenge(MINIMALE_GEOGRAPHISCHE_LAENGE_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_BREITE:
			return maximaleGeographischeBreite != MAXIMALE_GEOGRAPHISCHE_BREITE_EDEFAULT;
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_BREITE:
			return minimaleGeographischeBreite != MINIMALE_GEOGRAPHISCHE_BREITE_EDEFAULT;
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_LAENGE:
			return maximaleGeographischeLaenge != MAXIMALE_GEOGRAPHISCHE_LAENGE_EDEFAULT;
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_LAENGE:
			return minimaleGeographischeLaenge != MINIMALE_GEOGRAPHISCHE_LAENGE_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (maximaleGeographischeBreite: ");
		result.append(maximaleGeographischeBreite);
		result.append(", minimaleGeographischeBreite: ");
		result.append(minimaleGeographischeBreite);
		result.append(", maximaleGeographischeLaenge: ");
		result.append(maximaleGeographischeLaenge);
		result.append(", minimaleGeographischeLaenge: ");
		result.append(minimaleGeographischeLaenge);
		result.append(')');
		return result.toString();
	}

} // MassstaeblicheDarstellungImpl
