/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.model.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipseFactory;
import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;
import com.bitctrl.lib.eclipse.emf.eclipse.model.provider.NamedItemProvider;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungFactory;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.dobj.model.DobjFactory;

/**
 * This is the item provider adapter for a
 * {@link de.bsvrz.buv.plugin.darstellung.model.Darstellung} object. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 *
 * @generated
 */
public class DarstellungItemProvider extends NamedItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public DarstellungItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addSizePropertyDescriptor(object);
			addNetzPropertyDescriptor(object);
			addZoomSkalierungPropertyDescriptor(object);
			addZoomStufenPropertyDescriptor(object);
			addVerbindungslinieFarbePropertyDescriptor(object);
			addVerbindungslinieStaerkePropertyDescriptor(object);
			addVerbindungslinieStilPropertyDescriptor(object);
			addStoerfallverfahrenPropertyDescriptor(object);
			addAnzeigeVerfahrenPropertyDescriptor(object);
			addIdPropertyDescriptor(object);
			addZoomSuchfunktionPropertyDescriptor(object);
			addLegendeAktivierenPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Size feature.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSizePropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_Sized_size_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_Sized_size_feature", "_UI_Sized_type"),
						GefPackage.Literals.SIZED__SIZE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
						null, null));
	}

	/**
	 * This adds a property descriptor for the Netz feature.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected void addNetzPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_Darstellung_netz_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_Darstellung_netz_feature",
								"_UI_Darstellung_type"),
						DarstellungPackage.Literals.DARSTELLUNG__NETZ, true, false, false,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Zoom Skalierung feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addZoomSkalierungPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_Darstellung_zoomSkalierung_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_Darstellung_zoomSkalierung_feature",
								"_UI_Darstellung_type"),
						DarstellungPackage.Literals.DARSTELLUNG__ZOOM_SKALIERUNG, true, false, false,
						ItemPropertyDescriptor.REAL_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Zoom Stufen feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addZoomStufenPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_Darstellung_zoomStufen_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_Darstellung_zoomStufen_feature",
								"_UI_Darstellung_type"),
						DarstellungPackage.Literals.DARSTELLUNG__ZOOM_STUFEN, true, false, false,
						ItemPropertyDescriptor.REAL_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Verbindungslinie Farbe feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected void addVerbindungslinieFarbePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(), getResourceLocator(),
				getString("_UI_Darstellung_verbindungslinieFarbe_feature"),
				getString("_UI_PropertyDescriptor_description", "_UI_Darstellung_verbindungslinieFarbe_feature",
						"_UI_Darstellung_type"),
				DarstellungPackage.Literals.DARSTELLUNG__VERBINDUNGSLINIE_FARBE, true, false, false,
				ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Verbindungslinie Staerke feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected void addVerbindungslinieStaerkePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(), getResourceLocator(),
				getString("_UI_Darstellung_verbindungslinieStaerke_feature"),
				getString("_UI_PropertyDescriptor_description", "_UI_Darstellung_verbindungslinieStaerke_feature",
						"_UI_Darstellung_type"),
				DarstellungPackage.Literals.DARSTELLUNG__VERBINDUNGSLINIE_STAERKE, true, false, false,
				ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Verbindungslinie Stil feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected void addVerbindungslinieStilPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_Darstellung_verbindungslinieStil_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_Darstellung_verbindungslinieStil_feature",
								"_UI_Darstellung_type"),
						DarstellungPackage.Literals.DARSTELLUNG__VERBINDUNGSLINIE_STIL, true, false, false,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Stoerfallverfahren feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addStoerfallverfahrenPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_Darstellung_stoerfallverfahren_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_Darstellung_stoerfallverfahren_feature",
								"_UI_Darstellung_type"),
						DarstellungPackage.Literals.DARSTELLUNG__STOERFALLVERFAHREN, true, false, false,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Anzeige Verfahren feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addAnzeigeVerfahrenPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_Darstellung_anzeigeVerfahren_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_Darstellung_anzeigeVerfahren_feature",
								"_UI_Darstellung_type"),
						DarstellungPackage.Literals.DARSTELLUNG__ANZEIGE_VERFAHREN, true, false, false,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Id feature.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected void addIdPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_Darstellung_id_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_Darstellung_id_feature",
								"_UI_Darstellung_type"),
						DarstellungPackage.Literals.DARSTELLUNG__ID, true, false, false,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Zoom Suchfunktion feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addZoomSuchfunktionPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_Darstellung_zoomSuchfunktion_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_Darstellung_zoomSuchfunktion_feature",
								"_UI_Darstellung_type"),
						DarstellungPackage.Literals.DARSTELLUNG__ZOOM_SUCHFUNKTION, true, false, false,
						ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Legende Aktivieren feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLegendeAktivierenPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_Darstellung_legendeAktivieren_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_Darstellung_legendeAktivieren_feature",
								"_UI_Darstellung_type"),
						DarstellungPackage.Literals.DARSTELLUNG__LEGENDE_AKTIVIEREN, true, false, false,
						ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(DarstellungPackage.Literals.DARSTELLUNG__DO_TYPEN);
			childrenFeatures.add(DarstellungPackage.Literals.DARSTELLUNG__EBENEN);
			childrenFeatures.add(DarstellungPackage.Literals.DARSTELLUNG__PROPERTIES);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		final String label = ((Darstellung) object).getName();
		return label == null || label.length() == 0 ? getString("_UI_Darstellung_type")
				: getString("_UI_Darstellung_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(Darstellung.class)) {
		case DarstellungPackage.DARSTELLUNG__SIZE:
		case DarstellungPackage.DARSTELLUNG__NETZ:
		case DarstellungPackage.DARSTELLUNG__ZOOM_SKALIERUNG:
		case DarstellungPackage.DARSTELLUNG__ZOOM_STUFEN:
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_FARBE:
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_STAERKE:
		case DarstellungPackage.DARSTELLUNG__VERBINDUNGSLINIE_STIL:
		case DarstellungPackage.DARSTELLUNG__STOERFALLVERFAHREN:
		case DarstellungPackage.DARSTELLUNG__ANZEIGE_VERFAHREN:
		case DarstellungPackage.DARSTELLUNG__ID:
		case DarstellungPackage.DARSTELLUNG__ZOOM_SUCHFUNKTION:
		case DarstellungPackage.DARSTELLUNG__LEGENDE_AKTIVIEREN:
			fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
			return;
		case DarstellungPackage.DARSTELLUNG__DO_TYPEN:
		case DarstellungPackage.DARSTELLUNG__EBENEN:
		case DarstellungPackage.DARSTELLUNG__PROPERTIES:
			fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
			return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing the children that can be created under this object. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add(createChildParameter(DarstellungPackage.Literals.DARSTELLUNG__DO_TYPEN,
				DobjFactory.eINSTANCE.createConfiguratedDoTyp()));

		newChildDescriptors.add(createChildParameter(DarstellungPackage.Literals.DARSTELLUNG__EBENEN,
				DarstellungFactory.eINSTANCE.createEbene()));

		newChildDescriptors.add(createChildParameter(DarstellungPackage.Literals.DARSTELLUNG__EBENEN,
				DarstellungFactory.eINSTANCE.createAutoEbene()));

		newChildDescriptors.add(createChildParameter(DarstellungPackage.Literals.DARSTELLUNG__PROPERTIES,
				EclipseFactory.eINSTANCE.create(EclipsePackage.Literals.TUPEL)));
	}

	/**
	 * Return the resource locator for this item provider's resources. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return DarstellungEditPlugin.INSTANCE;
	}

}
