/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2020 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.model.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.lib.eclipse.emf.gef.model.Sized;

import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Ausschnitt;
import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungAdapter;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It provides
 * an adapter <code>createXXX</code> method for each class of the model. <!--
 * end-user-doc -->
 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage
 * @generated
 */
public class DarstellungAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected static DarstellungPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public DarstellungAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = DarstellungPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc --> This implementation returns <code>true</code> if
	 * the object is either the model's package or is an instance object of the
	 * model. <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject) object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected DarstellungSwitch<Adapter> modelSwitch = new DarstellungSwitch<>() {
		@Override
		public Adapter caseDarstellung(Darstellung object) {
			return createDarstellungAdapter();
		}

		@Override
		public Adapter caseAnsicht(Ansicht object) {
			return createAnsichtAdapter();
		}

		@Override
		public Adapter caseStilisierteDarstellung(StilisierteDarstellung object) {
			return createStilisierteDarstellungAdapter();
		}

		@Override
		public Adapter caseMassstaeblicheDarstellung(MassstaeblicheDarstellung object) {
			return createMassstaeblicheDarstellungAdapter();
		}

		@Override
		public Adapter caseEbene(Ebene object) {
			return createEbeneAdapter();
		}

		@Override
		public Adapter caseDarstellungsSpalte(DarstellungsSpalte object) {
			return createDarstellungsSpalteAdapter();
		}

		@Override
		public Adapter caseAutoEbene(AutoEbene object) {
			return createAutoEbeneAdapter();
		}

		@Override
		public Adapter caseAusschnitt(Ausschnitt object) {
			return createAusschnittAdapter();
		}

		@Override
		public Adapter caseNamed(Named object) {
			return createNamedAdapter();
		}

		@Override
		public Adapter caseSized(Sized object) {
			return createSizedAdapter();
		}

		@Override
		public Adapter defaultCase(EObject object) {
			return createEObjectAdapter();
		}
	};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject) target);
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.darstellung.model.Darstellung
	 * <em>Darstellung</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Darstellung
	 * @generated not
	 */
	public Adapter createDarstellungAdapter() {
		return new DarstellungAdapter();
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.darstellung.model.Ansicht <em>Ansicht</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ansicht
	 * @generated
	 */
	public Adapter createAnsichtAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung <em>Stilisierte Darstellung</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung
	 * @generated
	 */
	public Adapter createStilisierteDarstellungAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung <em>Massstaebliche Darstellung</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung
	 * @generated
	 */
	public Adapter createMassstaeblicheDarstellungAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.bitctrl.lib.eclipse.emf.eclipse.model.Named <em>Named</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.bitctrl.lib.eclipse.emf.eclipse.model.Named
	 * @generated
	 */
	public Adapter createNamedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link com.bitctrl.lib.eclipse.emf.gef.model.Sized <em>Sized</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see com.bitctrl.lib.eclipse.emf.gef.model.Sized
	 * @generated
	 */
	public Adapter createSizedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.darstellung.model.Ebene <em>Ebene</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ebene
	 * @generated
	 */
	public Adapter createEbeneAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte <em>Darstellungs Spalte</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte
	 * @generated
	 */
	public Adapter createDarstellungsSpalteAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene <em>Auto Ebene</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.darstellung.model.AutoEbene
	 * @generated
	 */
	public Adapter createAutoEbeneAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.darstellung.model.Ausschnitt <em>Ausschnitt</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ausschnitt
	 * @generated
	 */
	public Adapter createAusschnittAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} // DarstellungAdapterFactory
