/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.util;

import java.util.Objects;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * {@link Status}, der noch ein EMF Modell Objekt alt Attribut hat.
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 */
public class EObjectStatusImpl extends Status implements IAdaptable, EObjectStatus {

	private final EObject model;

	public EObjectStatusImpl(final int severity, final String pluginId, final int code, final String message,
			final EObject model) {
		super(severity, pluginId, code, message, null);
		this.model = model;
	}

	@Override
	public EObject getModellObject() {
		return model;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T getAdapter(final Class<T> adapter) {
		if (adapter == EObject.class) {
			return (T) model;
		} else if (adapter == DoModel.class && model instanceof DoModel) {
			return (T) model;
		} else if (adapter == DoTyp.class && model instanceof DoTyp) {
			return (T) model;
		} else if (adapter == SystemObject.class && model instanceof DoModel) {
			return (T) ((DoModel) model).getSystemObject();
		}
		return null;
	}

	@Override
	public int hashCode() {
		return Objects.hash(model);
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null || getClass() != obj.getClass()) {
			return false;
		}
		final EObjectStatusImpl other = (EObjectStatusImpl) obj;
		return Objects.equals(model, other.model);
	}
}
