/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.views.ansicht;

import java.beans.PropertyChangeListener;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.Disposable;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;

import de.bsvrz.buv.plugin.dobj.util.DobjIcons;

/**
 * Diese Aktion aktiviert und deaktiviert das {@link #ViewPanTool}.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @author BitCtrl Systems GmbH, Thomas Thierfelder
 */
class ViewPanAction extends Action implements Disposable, UpdateAction {

	private static final String ACTION_ID = "de.bsvrz.buv.plugin.darstellung.views.ansicht.pan";
	private final IAdaptable adaptable;
	private boolean lazyEnablement = true;
	private final ViewPanTool tool = new ViewPanTool();
	private final PropertyChangeListener propertyChangeListener = evt -> setChecked(tool.isActive());

	ViewPanAction(final IAdaptable adaptable) {
		super("Ausschnitt verschieben", IAction.AS_CHECK_BOX);
		setToolTipText("Verschiebt den angezeigten Ausschnitt mit der Maus.");
		setId(ACTION_ID);

		setImageDescriptor(DobjIcons.ActionPan.getImageDescriptor());

		this.adaptable = adaptable;
		setChecked(false);
		tool.addPropertyChangeListener(propertyChangeListener);
	}

	@Override
	public void dispose() {
		tool.removePropertyChangeListener(propertyChangeListener);
	}

	protected boolean calculateEnabled() {
		return getEditDomain() != null;
	}

	protected EditDomain getEditDomain() {
		return getAdaptable().getAdapter(EditDomain.class);
	}

	@Override
	public void run() {
		if (isChecked()) {
			getEditDomain().setActiveTool(tool);
		} else {
			getEditDomain().setActiveTool(getEditDomain().getDefaultTool());
		}
	}

	protected void execute(final Command command) {
		if (command == null || !command.canExecute()) {
			return;
		}
		getCommandStack().execute(command);
	}

	protected CommandStack getCommandStack() {
		return getAdaptable().getAdapter(CommandStack.class);
	}

	@Override
	public boolean isEnabled() {
		if (lazyEnablement) {
			setEnabled(calculateEnabled());
		}
		return super.isEnabled();
	}

	protected void refresh() {
		setEnabled(calculateEnabled());
	}

	public void setLazyEnablementCalculation(final boolean value) {
		lazyEnablement = value;
	}

	public IAdaptable getAdaptable() {
		return adaptable;
	}

	@Override
	public void update() {
		refresh();
	}

}
