/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Point;

/**
 * Implementiert die gemeinsamen Features aller Figures von Darstellungsobjekte.
 * <p>
 * Diese Klasse kann als Vorlage fÃ¼r neue Darstellungsobjekte verwendet werden
 * oder auch direkt abgeleitet werden.
 * </p>
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public class BaseDoFigure extends Figure implements DoFigure {

	private double zoom = 1.0;
	private double vonZoom;
	private double bisZoom = Double.MAX_VALUE;

	public double getZoom() {
		return zoom;
	}

	@Override
	public Point getHotspot() {
		return getLocation();
	}

	@Override
	public void setHotspot(final Point hotspot) {
		setLocation(hotspot);
	}

	@Override
	public void handleZoomChanged(final double newZoom) {
		if (zoom == newZoom) {
			return;
		}

		zoom = newZoom;

		aktualisiereSichtbarkeit();
	}

	@Override
	public void setSichtbareZoomStufe(final double vonZoom, final double bisZoom) {
		if (this.vonZoom == vonZoom && this.bisZoom == bisZoom) {
			return;
		}

		this.vonZoom = vonZoom;
		this.bisZoom = bisZoom;

		aktualisiereSichtbarkeit();
	}

	protected void aktualisiereSichtbarkeit() {
		setVisible(vonZoom <= zoom && zoom <= bisZoom);
	}

}
