/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;

import de.bsvrz.buv.plugin.dobj.model.DoModel;

/**
 * Schnittstelle für eine Figure die ein {@link DoModel} visualisiert.
 *
 * <p>
 * Die Figure-Location (obere linke Ecke der Bounds) eines Darstellungsobjekts
 * kann von der DoModel-Location abweichen. Um dann die DoModel-Location korrekt
 * der Figure zu übergeben, kann diese Schnittstelle verwendet werden. Der
 * Hotspot der Figure entspricht der DoModel-Location.
 *
 * <p>
 * <em>Hinweis:</em> Der Hotspot der Figure ist nicht die relative Verschiebung
 * der Figure-Location, sondern eine absolute Positionsangabe zur Platzierung
 * der Figure. Die Verschiebung ergibt sich aus der Differenz von Figure-Hotspot
 * und Figure-Location.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public interface DoFigure extends IFigure {

	/**
	 * Gibt die absolute Position des Hotspots der Figure zurück.
	 */
	Point getHotspot();

	/**
	 * Positioniert die Figure mit Hilfe ihres Hotspots.
	 */
	void setHotspot(Point hotspot);

	/**
	 * Weist die Figure an, den neuen Zoomlevel bei ihrer Darstellung zu
	 * berücksichtigen.
	 *
	 * @see #setSichtbareZoomStufe(double, double)
	 */
	void handleZoomChanged(final double newZoom);

	/**
	 * Legt die Zoomstufe fest, in der die Figure sichtbar ist. Außerhalb dieser
	 * Grenzen, muss die Figure unsichtbar sein.
	 *
	 * @see #handleZoomChanged(double)
	 */
	void setSichtbareZoomStufe(double vonZoom, double bisZoom);

}
