/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.actions;

import org.eclipse.ui.IWorkbenchPart;

import de.bsvrz.buv.plugin.dobj.tools.PolygonSelectionTool;
import de.bsvrz.buv.plugin.dobj.util.DobjIcons;

/**
 * Action zum Aktivieren des {@link PolygonSelectionTool}.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class PolygonSelectionAction extends AbstractToolAction {

	/**
	 * Initialsiert die Action.
	 *
	 * @param part
	 *            der Workbench Part für den die Action verwendet werden soll.
	 */
	public PolygonSelectionAction(final IWorkbenchPart part) {
		super(part, "Polygonselektion", new PolygonSelectionTool());
		setToolTipText("Polygonselektion");
		setId(DobjActionFactory.SELECTION_POLYGON.getCommandId());
		setActionDefinitionId(DobjActionFactory.SELECTION_POLYGON.getCommandId());
		setImageDescriptor(DobjIcons.ActionSelectionPolygon.getImageDescriptor());
	}
}
