/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.actions;

import org.eclipse.jface.action.Action;

import de.bsvrz.buv.plugin.dobj.internal.DobjMessages;
import de.bsvrz.buv.plugin.dobj.util.DobjIcons;
import de.bsvrz.buv.plugin.dobj.util.SelectionProperties;

/**
 * Aktiviert und Deaktiviert die Teilselektion. Wenn die Teilselektion aktiviert
 * ist, sollen nicht nur Objekt ausgewählt werden, die sich komplett innerhalb
 * des Selektionsrahmens befinden, sondern auch die die den Rahmen schneiden.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class ToggleTouchedSelectionAction extends Action {

	private final SelectionProperties properties;

	/**
	 * Initialisiert die Action.
	 *
	 * @param properties
	 *            die zu verwaltenden Selektionseigenschaften.
	 */
	public ToggleTouchedSelectionAction(final SelectionProperties properties) {
		super(DobjMessages.toggleTouchedSelectionLabel, AS_CHECK_BOX);
		this.properties = properties;

		setImageDescriptor(DobjIcons.ActionToggleTouchedSelection.getImageDescriptor());
		setToolTipText(DobjMessages.toggleTouchedSelectionTooltip);

		setId(DobjActionFactory.TOGGLE_TOUCHED_SELECTION.getCommandId());
		setActionDefinitionId(DobjActionFactory.TOGGLE_TOUCHED_SELECTION.getCommandId());

		setChecked(properties.isSelectTouched());
	}

	@Override
	public void run() {
		properties.setSelectTouched(!properties.isSelectTouched());
		setChecked(properties.isSelectTouched());
	}

}
