/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

import de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;

public final class DatenstatusMediator {

	private static final class KeineQuelleFarbeMediator
			extends AbstractMediator<DatenstatusDecorator, DatenstatusFigure> {

		KeineQuelleFarbeMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, DatenstatusDecorator.class,
					DobjDecoratorPackage.Literals.DATENSTATUS_DECORATOR__KEINE_QUELLE_FARBE);
		}

		@Override
		protected void mediate(final DatenstatusDecorator decorator) {
			final RGB rgb = decorator.getKeineQuelleFarbe();
			final Color color = getResourceManager().createColor(rgb);
			getFigure().setKeineQuelleFarbe(color);
		}

	}

	private static final class KeineDatenFarbeMediator
			extends AbstractMediator<DatenstatusDecorator, DatenstatusFigure> {

		KeineDatenFarbeMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, DatenstatusDecorator.class,
					DobjDecoratorPackage.Literals.DATENSTATUS_DECORATOR__KEINE_DATEN_FARBE);
		}

		@Override
		protected void mediate(final DatenstatusDecorator decorator) {
			final RGB rgb = decorator.getKeineDatenFarbe();
			final Color color = getResourceManager().createColor(rgb);
			getFigure().setKeineDatenFarbe(color);
		}

	}

	private static final class NutzDatenFarbeMediator
			extends AbstractMediator<DatenstatusDecorator, DatenstatusFigure> {

		NutzDatenFarbeMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, DatenstatusDecorator.class,
					DobjDecoratorPackage.Literals.DATENSTATUS_DECORATOR__NUTZDATEN_FARBE);
		}

		@Override
		protected void mediate(final DatenstatusDecorator decorator) {
			final RGB rgb = decorator.getNutzdatenFarbe();
			final Color color = getResourceManager().createColor(rgb);
			getFigure().setNutzdatenFarbe(color);
		}

	}

	private final KeineQuelleFarbeMediator keineQuelleFarbeMediator;
	private final KeineDatenFarbeMediator keineDatenFarbeMediator;
	private final NutzDatenFarbeMediator nutzDatenFarbeMediator;

	public DatenstatusMediator(final DoModelEditPart<?, ?> editPart) {
		keineQuelleFarbeMediator = new KeineQuelleFarbeMediator(editPart);
		keineDatenFarbeMediator = new KeineDatenFarbeMediator(editPart);
		nutzDatenFarbeMediator = new NutzDatenFarbeMediator(editPart);
	}

	public void mediate() {
		keineQuelleFarbeMediator.mediate();
		keineDatenFarbeMediator.mediate();
		nutzDatenFarbeMediator.mediate();
	}

}
