/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator;

import org.eclipse.draw2d.IFigure;

import de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten;

public interface LinienabstandFigure extends IFigure {

	int getLinienabstand();

	void setLinienabstand(int linienabstand);

	default Zoomverhalten getLinienabstandZoomverhalten() {
		return Zoomverhalten.STATISCHES_ZOOMVERHALTEN;
	}

	default void setLinienabstandZoomverhalten(final Zoomverhalten zoomverhalten) {
		// leere default Implementierung
	}

	default void setLinienabstandMinimaleZoomstufe(final double minimaleZoomstufe) {
		// leere default Implementierung
	}

	default double getLinienabstandMinimaleZoomstufe() {
		return Double.MIN_NORMAL;
	}

	default void setLinienabstandMaximaleZoomstufe(final double maximaleZoomstufe) {
		// leere default Implementierung
	}

	default double getLinienabstandMaximaleZoomstufe() {
		return Double.MAX_VALUE;
	}

	default void setLinienabstandMinimum(final int minimaleLinienabstand) {
		// leere default Implementierung
	}

	default int getLinienabstandMinimum() {
		return getLinienabstand();
	}

	default void setLinienabstandMaximum(final int maximaleLinienabstand) {
		// leere default Implementierung
	}

	default int getLinienabstandMaximum() {
		return getLinienabstand();
	}

}
