/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;

public final class LinienabstandMediator extends AbstractMediator<LinienabstandDecorator, LinienabstandFigure> {

	public LinienabstandMediator(final DoModelEditPart<?, ?> editPart) {
		super(editPart, LinienabstandDecorator.class,
				DobjDecoratorPackage.Literals.LINIENABSTAND_DECORATOR__LINIENABSTAND);
	}

	@Override
	protected void mediate(final LinienabstandDecorator decorator) {
		getFigure().setLinienabstand(decorator.getLinienabstand());
	}

}
