/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;

/**
 * Zusammenfassender Mediator für alle Attribute des
 * {@link LinienabstandZoomDecorator}s.
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 */
public class LinienabstandZoomMediator {

	private final LinienabstandMaximumMediator linienabstandMaximumMediator;
	private final LinienabstandMinimumMediator linienabstandMinimumMediator;
	private final LinienabstandZoomverhaltenMediator linienabstandZoomverhaltenMediator;
	private final LinienabstandMaximaleZoomstufeMediator linienabstandMaximaleZoomstufeMediator;
	private final LinienabstandMinimaleZoomstufeMediator linienabstandMinimaleZoomstufeMediator;
	private final LinienabstandMediator linienabstandMediator;

	private static final class LinienabstandMaximumMediator
			extends AbstractMediator<LinienabstandZoomDecorator, LinienabstandFigure> {

		LinienabstandMaximumMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, LinienabstandZoomDecorator.class,
					DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM);
		}

		@Override
		protected void mediate(final LinienabstandZoomDecorator decorator) {
			getFigure().setLinienabstandMaximum(decorator.getLinienabstandMaximum());
		}

	}

	private static final class LinienabstandMinimumMediator
			extends AbstractMediator<LinienabstandZoomDecorator, LinienabstandFigure> {

		LinienabstandMinimumMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, LinienabstandZoomDecorator.class,
					DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM);
		}

		@Override
		protected void mediate(final LinienabstandZoomDecorator decorator) {
			getFigure().setLinienabstandMinimum(decorator.getLinienabstandMinimum());
		}

	}

	private static final class LinienabstandZoomverhaltenMediator
			extends AbstractMediator<LinienabstandZoomDecorator, LinienabstandFigure> {

		LinienabstandZoomverhaltenMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, LinienabstandZoomDecorator.class,
					DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN);
		}

		@Override
		protected void mediate(final LinienabstandZoomDecorator decorator) {
			getFigure().setLinienabstandZoomverhalten(decorator.getLinienabstandZoomverhalten());
		}

	}

	private static final class LinienabstandMaximaleZoomstufeMediator
			extends AbstractMediator<LinienabstandZoomDecorator, LinienabstandFigure> {

		LinienabstandMaximaleZoomstufeMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, LinienabstandZoomDecorator.class,
					DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE);
		}

		@Override
		protected void mediate(final LinienabstandZoomDecorator decorator) {

			double bisZoom;
			final double zoomSkalierung = getZoomSkalierung();
			bisZoom = decorator.getLinienabstandMaximaleZoomstufe();
			bisZoom /= 100;
			bisZoom /= zoomSkalierung;

			getFigure().setLinienabstandMaximaleZoomstufe(bisZoom);
		}

		private double getZoomSkalierung() {
			final Darstellung darstellung = getEditPart().getDarstellung();
			if (darstellung != null) {
				return darstellung.getZoomSkalierung();
			}

			// fallback
			return 1.0;
		}
	}

	private static final class LinienabstandMinimaleZoomstufeMediator
			extends AbstractMediator<LinienabstandZoomDecorator, LinienabstandFigure> {

		LinienabstandMinimaleZoomstufeMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, LinienabstandZoomDecorator.class,
					DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE);
		}

		@Override
		protected void mediate(final LinienabstandZoomDecorator decorator) {

			final double zoomSkalierung = getZoomSkalierung();
			double bisZoom = decorator.getLinienabstandMinimaleZoomstufe();
			bisZoom /= 100;
			bisZoom /= zoomSkalierung;
			getFigure().setLinienabstandMinimaleZoomstufe(bisZoom);
		}

		private double getZoomSkalierung() {
			final Darstellung darstellung = getEditPart().getDarstellung();
			if (darstellung != null) {
				return darstellung.getZoomSkalierung();
			}

			// fallback
			return 1.0;
		}
	}

	private static final class LinienabstandMediator
			extends AbstractMediator<LinienabstandZoomDecorator, LinienabstandFigure> {

		LinienabstandMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, LinienabstandZoomDecorator.class,
					DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND);
		}

		@Override
		protected void mediate(final LinienabstandZoomDecorator decorator) {
			getFigure().setLinienabstand(decorator.getLinienabstand());
		}

	}

	public LinienabstandZoomMediator(final DoModelEditPart<?, ?> editPart) {
		linienabstandMaximumMediator = new LinienabstandMaximumMediator(editPart);
		linienabstandMinimumMediator = new LinienabstandMinimumMediator(editPart);
		linienabstandZoomverhaltenMediator = new LinienabstandZoomverhaltenMediator(editPart);
		linienabstandMaximaleZoomstufeMediator = new LinienabstandMaximaleZoomstufeMediator(editPart);
		linienabstandMinimaleZoomstufeMediator = new LinienabstandMinimaleZoomstufeMediator(editPart);
		linienabstandMediator = new LinienabstandMediator(editPart);

	}

	public void mediate() {
		linienabstandZoomverhaltenMediator.mediate();
		linienabstandMaximumMediator.mediate();
		linienabstandMinimumMediator.mediate();
		linienabstandMaximaleZoomstufeMediator.mediate();
		linienabstandMinimaleZoomstufeMediator.mediate();
		linienabstandMediator.mediate();
	}

}
