/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Font;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;

public final class SchriftMediator extends AbstractMediator<SchriftDecorator, IFigure> {

	public SchriftMediator(final DoModelEditPart<?, ?> editPart) {
		super(editPart, SchriftDecorator.class, DobjDecoratorPackage.Literals.SCHRIFT_DECORATOR__SCHRIFT);
	}

	@Override
	protected void mediate(final SchriftDecorator decorator) {
		if (decorator.isSetSchrift()) {
			final FontDescriptor descriptor = FontDescriptor.createFrom(decorator.getSchrift());
			final Font font = getResourceManager().get(descriptor);
			getFigure().setFont(font);
		} else {
			getFigure().setFont(null);
		}
	}

}
