/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;

/**
 * Mediator für die Farben von {@link StoerfallIndikatorDecorator}en.
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 */
public final class StoerfallIndikatorMediator {

	private static final class StoerungFarbeMediator
			extends AbstractMediator<StoerfallIndikatorDecorator, StoerfallIndikatorFigure> {

		StoerungFarbeMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, StoerfallIndikatorDecorator.class,
					DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__STOERUNG_FARBE);
		}

		@Override
		protected void mediate(final StoerfallIndikatorDecorator decorator) {
			final RGB rgb = decorator.getStoerungFarbe();
			final Color color = getResourceManager().createColor(rgb);
			getFigure().setStoerungFarbe(color);
		}

	}

	private static final class KeineAussageFarbeMediator
			extends AbstractMediator<StoerfallIndikatorDecorator, StoerfallIndikatorFigure> {

		KeineAussageFarbeMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, StoerfallIndikatorDecorator.class,
					DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__KEINE_AUSSAGE_FARBE);
		}

		@Override
		protected void mediate(final StoerfallIndikatorDecorator decorator) {
			final RGB rgb = decorator.getKeineAussageFarbe();
			final Color color = getResourceManager().createColor(rgb);
			getFigure().setKeineAussageFarbe(color);
		}

	}

	private static final class FreierVerkehrFarbeMediator
			extends AbstractMediator<StoerfallIndikatorDecorator, StoerfallIndikatorFigure> {

		FreierVerkehrFarbeMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, StoerfallIndikatorDecorator.class,
					DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__FREIER_VERKEHR_FARBE);
		}

		@Override
		protected void mediate(final StoerfallIndikatorDecorator decorator) {
			final RGB rgb = decorator.getFreierVerkehrFarbe();
			final Color color = getResourceManager().createColor(rgb);
			getFigure().setFreierVerkehrFarbe(color);
		}
	}

	private static final class LebhafterVerkehrFarbeMediator
			extends AbstractMediator<StoerfallIndikatorDecorator, StoerfallIndikatorFigure> {

		LebhafterVerkehrFarbeMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, StoerfallIndikatorDecorator.class,
					DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__LEBHAFTER_VERKEHR_FARBE);
		}

		@Override
		protected void mediate(final StoerfallIndikatorDecorator decorator) {
			final RGB rgb = decorator.getLebhafterVerkehrFarbe();
			final Color color = getResourceManager().createColor(rgb);
			getFigure().setLebhafterVerkehrFarbe(color);
		}
	}

	private static final class DichterVerkehrFarbeMediator
			extends AbstractMediator<StoerfallIndikatorDecorator, StoerfallIndikatorFigure> {

		DichterVerkehrFarbeMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, StoerfallIndikatorDecorator.class,
					DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__DICHTER_VERKEHR_FARBE);
		}

		@Override
		protected void mediate(final StoerfallIndikatorDecorator decorator) {
			final RGB rgb = decorator.getDichterVerkehrFarbe();
			final Color color = getResourceManager().createColor(rgb);
			getFigure().setDichterVerkehrFarbe(color);
		}
	}

	private static final class ZaehfliessenderVerkehrFarbeMediator
			extends AbstractMediator<StoerfallIndikatorDecorator, StoerfallIndikatorFigure> {

		ZaehfliessenderVerkehrFarbeMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, StoerfallIndikatorDecorator.class,
					DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__ZAEHFLIESSENDER_VERKEHR_FARBE);
		}

		@Override
		protected void mediate(final StoerfallIndikatorDecorator decorator) {
			final RGB rgb = decorator.getZaehfliessenderVerkehrFarbe();
			final Color color = getResourceManager().createColor(rgb);
			getFigure().setZaehfliessenderVerkehrFarbe(color);
		}
	}

	private static final class StockenderVerkehrFarbeMediator
			extends AbstractMediator<StoerfallIndikatorDecorator, StoerfallIndikatorFigure> {

		StockenderVerkehrFarbeMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, StoerfallIndikatorDecorator.class,
					DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__STOCKENDER_VERKEHR_FARBE);
		}

		@Override
		protected void mediate(final StoerfallIndikatorDecorator decorator) {
			final RGB rgb = decorator.getStockenderVerkehrFarbe();
			final Color color = getResourceManager().createColor(rgb);
			getFigure().setStockenderVerkehrFarbe(color);
		}
	}

	private static final class StauFarbeMediator
			extends AbstractMediator<StoerfallIndikatorDecorator, StoerfallIndikatorFigure> {

		StauFarbeMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, StoerfallIndikatorDecorator.class,
					DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__STAU_FARBE);
		}

		@Override
		protected void mediate(final StoerfallIndikatorDecorator decorator) {
			final RGB rgb = decorator.getStauFarbe();
			final Color color = getResourceManager().createColor(rgb);
			getFigure().setStauFarbe(color);
		}
	}

	private final StoerungFarbeMediator stoerungFarbeMediator;
	private final KeineAussageFarbeMediator keineAussageFarbeMediator;
	private final FreierVerkehrFarbeMediator freierVerkehrFarbeMediator;
	private final LebhafterVerkehrFarbeMediator lebhafterVerkehrFarbeMediator;
	private final DichterVerkehrFarbeMediator dichterVerkehrFarbeMediator;
	private final ZaehfliessenderVerkehrFarbeMediator zaehfliessenderVerkehrFarbeMediator;
	private final StockenderVerkehrFarbeMediator stockenderVerkehrFarbeMediator;
	private final StauFarbeMediator stauFarbeMediator;

	public StoerfallIndikatorMediator(final DoModelEditPart<?, ?> editPart) {
		stoerungFarbeMediator = new StoerungFarbeMediator(editPart);
		keineAussageFarbeMediator = new KeineAussageFarbeMediator(editPart);
		freierVerkehrFarbeMediator = new FreierVerkehrFarbeMediator(editPart);
		lebhafterVerkehrFarbeMediator = new LebhafterVerkehrFarbeMediator(editPart);
		dichterVerkehrFarbeMediator = new DichterVerkehrFarbeMediator(editPart);
		zaehfliessenderVerkehrFarbeMediator = new ZaehfliessenderVerkehrFarbeMediator(editPart);
		stockenderVerkehrFarbeMediator = new StockenderVerkehrFarbeMediator(editPart);
		stauFarbeMediator = new StauFarbeMediator(editPart);
	}

	public void mediate() {
		stoerungFarbeMediator.mediate();
		keineAussageFarbeMediator.mediate();
		freierVerkehrFarbeMediator.mediate();
		lebhafterVerkehrFarbeMediator.mediate();
		dichterVerkehrFarbeMediator.mediate();
		zaehfliessenderVerkehrFarbeMediator.mediate();
		stockenderVerkehrFarbeMediator.mediate();
		stauFarbeMediator.mediate();

	}
}
