/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.UnsetCommand;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

public final class GroesseDecoratorPropertySection extends AbstractSection<GroesseDecorator> {

	private Spinner breiteSpinner;
	private Spinner hoeheSpinner;
	private Button useDefaultButton;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final Composite container = erzeugeContainer(parent);
		createGroesse(container);
	}

	private Composite erzeugeContainer(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);
		return container;
	}

	private void createGroesse(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		breiteSpinner = new Spinner(parent, SWT.BORDER);
		breiteSpinner.setMinimum(1);
		breiteSpinner.setMaximum(Integer.MAX_VALUE);
		breiteSpinner.setIncrement(10);
		breiteSpinner.setPageIncrement(100);
		factory.adapt(parent);
		final FormData breiteSpinnerData = new FormData();
		breiteSpinnerData.left = new FormAttachment(0, STANDARD_LABEL_WIDTH);
		breiteSpinnerData.width = 100;
		breiteSpinner.setLayoutData(breiteSpinnerData);

		final Label groesseLabel = factory.createLabel(parent, "Größe:");
		final FormData breiteLabelData = new FormData();
		breiteLabelData.top = new FormAttachment(breiteSpinner, 0, SWT.CENTER);
		groesseLabel.setLayoutData(breiteLabelData);

		final Label xLabel = factory.createLabel(parent, "x");
		final FormData hoeheLabelData = new FormData();
		hoeheLabelData.top = new FormAttachment(breiteSpinner, 0, SWT.CENTER);
		hoeheLabelData.left = new FormAttachment(breiteSpinner, ITabbedPropertyConstants.HSPACE);
		xLabel.setLayoutData(hoeheLabelData);

		hoeheSpinner = new Spinner(parent, SWT.BORDER);
		hoeheSpinner.setMinimum(1);
		hoeheSpinner.setMaximum(Integer.MAX_VALUE);
		hoeheSpinner.setIncrement(10);
		hoeheSpinner.setPageIncrement(100);
		factory.adapt(parent);
		final FormData hoeheSpinnerData = new FormData();
		hoeheSpinnerData.left = new FormAttachment(xLabel, ITabbedPropertyConstants.HSPACE);
		hoeheSpinnerData.width = 100;
		hoeheSpinner.setLayoutData(hoeheSpinnerData);

		useDefaultButton = factory.createButton(parent, "Defaultwert verwenden", SWT.CHECK);
		final FormData useDefaultData = new FormData();
		useDefaultData.top = new FormAttachment(hoeheSpinner, 0, SWT.CENTER);
		useDefaultData.left = new FormAttachment(hoeheSpinner, ITabbedPropertyConstants.HSPACE);
		useDefaultButton.setLayoutData(useDefaultData);

		breiteSpinner.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				setGroesseFromWidget();
			}

		});
		hoeheSpinner.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				setGroesseFromWidget();
			}

		});
		useDefaultButton.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				setUseDefaultFromWidget();
			}

		});
	}

	private void setGroesseFromWidget() {
		final Dimension value = new Dimension(breiteSpinner.getSelection(), hoeheSpinner.getSelection());
		final SetCommand cmd = new SetCommand(getElement(), DobjDecoratorPackage.Literals.GROESSE_DECORATOR__GROESSE,
				value);
		getCommandStack().execute(cmd);
	}

	private void setUseDefaultFromWidget() {
		if (useDefaultButton.getSelection()) {
			final UnsetCommand cmd = new UnsetCommand(getElement(),
					DobjDecoratorPackage.Literals.GROESSE_DECORATOR__GROESSE);
			getCommandStack().execute(cmd);
		} else {
			final Dimension value = getElement().getGroesse();
			final SetCommand cmd = new SetCommand(getElement(),
					DobjDecoratorPackage.Literals.GROESSE_DECORATOR__GROESSE, value);
			getCommandStack().execute(cmd);
		}
	}

	@Override
	public void refresh() {
		setGroesseToWidget();
		setUseDefaultToWodget();
	}

	private void setGroesseToWidget() {
		final boolean isChanged = breiteSpinner.getSelection() != getElement().getGroesse().width;
		if (isChanged) {
			breiteSpinner.setSelection(getElement().getGroesse().width);
			hoeheSpinner.setSelection(getElement().getGroesse().height);
		}
	}

	private void setUseDefaultToWodget() {
		final boolean useDefault = !getElement().isSetGroesse();
		useDefaultButton.setSelection(useDefault);
		breiteSpinner.setEnabled(!useDefault);
		hoeheSpinner.setEnabled(!useDefault);
	}

}
