/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import static org.eclipse.swt.SWT.BORDER;
import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.swt.SWT.CHECK;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.UnsetCommand;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

public final class LinienabstandDecoratorPropertySection extends AbstractSection<LinienabstandDecorator> {

	private Label linienabstandLabel;
	private Spinner linienabstand;
	private Button linienabstandUseDefault;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createLinienabstand(container);
	}

	private void createLinienabstand(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen

		linienabstandLabel = factory.createLabel(parent, "Linienabstand:");
		linienabstand = new Spinner(parent, BORDER);
		linienabstand.setMinimum(Integer.MIN_VALUE);
		linienabstand.setMaximum(Integer.MAX_VALUE);
		linienabstand.setIncrement(1);
		linienabstand.setPageIncrement(10);
		factory.adapt(parent);
		linienabstandUseDefault = factory.createButton(parent, "Defaultwert verwenden", CHECK);

		// Widgets layouten
		final FormData spinnerData = new FormData();
		spinnerData.left = new FormAttachment(linienabstandLabel, HSPACE);
		spinnerData.width = 150;
		spinnerData.top = new FormAttachment(0, 0);
		linienabstand.setLayoutData(spinnerData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(linienabstand, 0, CENTER);
		linienabstandLabel.setLayoutData(labelData);
		final FormData useDefaultData = new FormData();
		useDefaultData.left = new FormAttachment(linienabstand, 0, HSPACE);
		useDefaultData.top = new FormAttachment(linienabstand, 0, CENTER);
		linienabstandUseDefault.setLayoutData(useDefaultData);

		// Listener anmelden
		linienabstand.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final int value = linienabstand.getSelection();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENABSTAND_DECORATOR__LINIENABSTAND, value);
				getCommandStack().execute(cmd);
			}

		});
		linienabstandUseDefault.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				if (linienabstandUseDefault.getSelection()) {
					final UnsetCommand cmd = new UnsetCommand(getElement(),
							DobjDecoratorPackage.Literals.LINIENABSTAND_DECORATOR__LINIENABSTAND);
					getCommandStack().execute(cmd);
				} else {
					final int value = getElement().getLinienabstand();
					final SetCommand cmd = new SetCommand(getElement(),
							DobjDecoratorPackage.Literals.LINIENABSTAND_DECORATOR__LINIENABSTAND, value);
					getCommandStack().execute(cmd);
				}
			}

		});
	}

	@Override
	public void refresh() {
		setLinienabstandToWidget();
		disableLinienabstandIfNecessary();
	}

	private void setLinienabstandToWidget() {
		final boolean isChanged = linienabstand.getSelection() != getElement().getLinienabstand();
		if (isChanged) {
			linienabstand.setSelection(getElement().getLinienabstand());
		}
	}

	private void disableLinienabstandIfNecessary() {
		final boolean isDoKomponente = getElement().eContainer() instanceof DoKomponente;
		final boolean useDefault = !getElement().isSetLinienabstand();

		linienabstandUseDefault.setSelection(useDefault);

		final boolean enabled = !isDoKomponente && !useDefault;
		linienabstand.setEnabled(enabled);
		linienabstandLabel.setEnabled(enabled);
		linienabstandUseDefault.setEnabled(!isDoKomponente);
	}

}
