/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import static org.eclipse.swt.SWT.BORDER;
import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.swt.SWT.CHECK;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.VMARGIN;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.UnsetCommand;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

public final class LinienabstandZoomDecoratorPropertySection extends AbstractSection<LinienabstandZoomDecorator> {

	private final class LinienabstandUseDefaultSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			if (linienabstandUseDefault.getSelection()) {
				final UnsetCommand cmd = new UnsetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND);
				getCommandStack().execute(cmd);
			} else {
				final int value = getElement().getLinienabstand();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND, value);
				getCommandStack().execute(cmd);
			}
		}
	}

	private final class LinienabstandSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			final int value = linienabstand.getSelection();
			final SetCommand cmd = new SetCommand(getElement(),
					DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND, value);
			getCommandStack().execute(cmd);
		}
	}

	private final class MaximalZoomstufeUseDefaultSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			if (maximaleZoomstufeUseDefault.getSelection()) {
				final UnsetCommand cmd = new UnsetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE);
				getCommandStack().execute(cmd);
			} else {
				final int value = getElement().getLinienabstandMaximaleZoomstufe();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE,
						value);
				getCommandStack().execute(cmd);
			}
		}
	}

	private final class MaximalLinienabstandUseDefaultSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			if (maximaleLinienabstandUseDefault.getSelection()) {
				final UnsetCommand cmd = new UnsetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM);
				getCommandStack().execute(cmd);
			} else {
				final int value = getElement().getLinienabstandMaximum();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM, value);
				getCommandStack().execute(cmd);
			}
		}
	}

	private final class MaximalZoomstufeSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			final int wert = maximaleZoomstufeSpinner.getSelection();
			final SetCommand cmd = new SetCommand(getElement(),
					DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE, wert);
			getCommandStack().execute(cmd);

		}
	}

	private final class MaximalLinienabstandSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			final int wert = maximaleLinienabstandSpinner.getSelection();
			final SetCommand cmd = new SetCommand(getElement(),
					DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM, wert);
			getCommandStack().execute(cmd);

		}
	}

	private final class MinimalZoomstufeUseDefaultSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			if (minimaleZoomstufeUseDefault.getSelection()) {
				final UnsetCommand cmd = new UnsetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE);
				getCommandStack().execute(cmd);
			} else {
				final int value = getElement().getLinienabstandMinimaleZoomstufe();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE,
						value);
				getCommandStack().execute(cmd);
			}
		}
	}

	private final class MinimalLinienabstandUseDefaultSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			if (minimaleLinienabstandUseDefault.getSelection()) {
				final UnsetCommand cmd = new UnsetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM);
				getCommandStack().execute(cmd);
			} else {
				final int value = getElement().getLinienabstandMinimum();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM, value);
				getCommandStack().execute(cmd);
			}
		}
	}

	private final class MinimalZoomstufeSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			final int wert = minimaleZoomstufeSpinner.getSelection();
			final SetCommand cmd = new SetCommand(getElement(),
					DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE, wert);
			getCommandStack().execute(cmd);

		}
	}

	private final class MinimalLinienabstandSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			final int wert = minimaleLinienabstandSpinner.getSelection();
			final SetCommand cmd = new SetCommand(getElement(),
					DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM, wert);
			getCommandStack().execute(cmd);

		}
	}

	private Label linienabstandLabel;
	private Spinner linienabstand;
	private Button linienabstandUseDefault;
	private Button statischesZoomverhaltenBtn;
	private Group statischesZoomverhaltenGroup;
	private Button dynamischesZoomverhaltenBtn;
	private Group dynamischesZoomverhaltenGroup;
	private Spinner minimaleZoomstufeSpinner;
	private Button minimaleZoomstufeUseDefault;
	private Spinner maximaleZoomstufeSpinner;
	private Button maximaleZoomstufeUseDefault;
	private Spinner minimaleLinienabstandSpinner;
	private Button minimaleLinienabstandUseDefault;
	private Spinner maximaleLinienabstandSpinner;
	private Button maximaleLinienabstandUseDefault;
	private Label labelMinZoomstufe;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		final Group group = factory.createGroup(container, "Linienabstand");
		final FormLayout layout = new FormLayout();
		layout.marginWidth = ITabbedPropertyConstants.HSPACE + 2;
		layout.marginHeight = ITabbedPropertyConstants.VSPACE;
		layout.spacing = ITabbedPropertyConstants.VMARGIN + 1;
		group.setLayout(layout);

		final FormData data = new FormData();
		data.left = new FormAttachment(0, HSPACE);
		data.right = new FormAttachment(100);
		data.top = new FormAttachment(container, 0, SWT.TOP);
		group.setLayoutData(data);

		createStatischesZoomverhalten(group);

		createDynamischesZoomverhalten(group);

	}

	private void createDynamischesZoomverhalten(final Composite container) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		dynamischesZoomverhaltenBtn = getWidgetFactory().createButton(container,
				Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN.getLiteral(), SWT.RADIO);

		FormData data = new FormData();
		data.left = new FormAttachment(0, HSPACE);
		data.top = new FormAttachment(statischesZoomverhaltenGroup, ITabbedPropertyConstants.VSPACE, SWT.BOTTOM);
		dynamischesZoomverhaltenBtn.setLayoutData(data);

		dynamischesZoomverhaltenGroup = getWidgetFactory().createGroup(container, "");
		final FormLayout layout = new FormLayout();
		layout.marginWidth = ITabbedPropertyConstants.HSPACE + 2;
		layout.marginHeight = ITabbedPropertyConstants.VSPACE;
		layout.spacing = ITabbedPropertyConstants.VMARGIN + 1;
		dynamischesZoomverhaltenGroup.setLayout(layout);

		data = new FormData();
		data.left = new FormAttachment(0, HSPACE);
		data.right = new FormAttachment(100);
		data.top = new FormAttachment(dynamischesZoomverhaltenBtn, 0, SWT.TOP);
		dynamischesZoomverhaltenGroup.setLayoutData(data);

		createDynamischeZoomstufen(factory);

		createDynamischeLinienabstand(factory);

		dynamischesZoomverhaltenBtn.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN,
						Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN);
				getCommandStack().execute(cmd);
			}
		});

	}

	private void createDynamischeZoomstufen(final TabbedPropertySheetWidgetFactory factory) {
		labelMinZoomstufe = factory.createLabel(dynamischesZoomverhaltenGroup, "Minimale Zoomstufe (in %):");
		FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(0, VMARGIN);
		labelMinZoomstufe.setLayoutData(labelData);

		minimaleZoomstufeSpinner = new Spinner(dynamischesZoomverhaltenGroup, SWT.BORDER);
		minimaleZoomstufeSpinner.setValues(1, 1, Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(minimaleZoomstufeSpinner);
		FormData textData = new FormData();
		textData.left = new FormAttachment(labelMinZoomstufe, HSPACE);
		textData.width = 150;
		textData.top = new FormAttachment(labelMinZoomstufe, 0, CENTER);
		minimaleZoomstufeSpinner.setLayoutData(textData);
		minimaleZoomstufeSpinner.addSelectionListener(new MinimalZoomstufeSelectionAdapter());

		minimaleZoomstufeUseDefault = factory.createButton(dynamischesZoomverhaltenGroup, "default", SWT.CHECK);
		textData = new FormData();
		textData.left = new FormAttachment(minimaleZoomstufeSpinner, HSPACE);
		textData.width = 70;
		textData.top = new FormAttachment(labelMinZoomstufe, 0, CENTER);
		minimaleZoomstufeUseDefault.setLayoutData(textData);

		minimaleZoomstufeUseDefault.addSelectionListener(new MinimalZoomstufeUseDefaultSelectionAdapter());

		final Label labelMaxZoomstufe = factory.createLabel(dynamischesZoomverhaltenGroup,
				"Maximale Zoomstufe (in %):");
		labelData = new FormData();
		labelData.left = new FormAttachment(minimaleZoomstufeUseDefault, HSPACE);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(0, VMARGIN);
		labelMaxZoomstufe.setLayoutData(labelData);

		maximaleZoomstufeSpinner = new Spinner(dynamischesZoomverhaltenGroup, SWT.BORDER);
		maximaleZoomstufeSpinner.setValues(5000, 0, Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(maximaleZoomstufeSpinner);
		textData = new FormData();
		textData.left = new FormAttachment(labelMaxZoomstufe, HSPACE);
		textData.width = 150;
		textData.top = new FormAttachment(maximaleZoomstufeSpinner, 0, CENTER);
		maximaleZoomstufeSpinner.setLayoutData(textData);
		maximaleZoomstufeSpinner.addSelectionListener(new MaximalZoomstufeSelectionAdapter());

		maximaleZoomstufeUseDefault = factory.createButton(dynamischesZoomverhaltenGroup, "default", SWT.CHECK);
		textData = new FormData();
		textData.left = new FormAttachment(maximaleZoomstufeSpinner, HSPACE);
		textData.width = 70;
		textData.top = new FormAttachment(labelMaxZoomstufe, 0, CENTER);
		maximaleZoomstufeUseDefault.setLayoutData(textData);
		maximaleZoomstufeUseDefault.addSelectionListener(new MaximalZoomstufeUseDefaultSelectionAdapter());
	}

	private void createDynamischeLinienabstand(final TabbedPropertySheetWidgetFactory factory) {
		FormData labelData;
		FormData textData;
		final Label labelMinLinienabstand = factory.createLabel(dynamischesZoomverhaltenGroup,
				"Minimaler Linienabstand:");
		labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(labelMinZoomstufe, ITabbedPropertyConstants.VSPACE, SWT.BOTTOM);
		labelMinLinienabstand.setLayoutData(labelData);

		minimaleLinienabstandSpinner = new Spinner(dynamischesZoomverhaltenGroup, SWT.BORDER);
		minimaleLinienabstandSpinner.setValues(1, 1, Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(minimaleLinienabstandSpinner);
		textData = new FormData();
		textData.left = new FormAttachment(labelMinLinienabstand, HSPACE);
		textData.width = 150;
		textData.top = new FormAttachment(labelMinLinienabstand, 0, SWT.TOP);
		minimaleLinienabstandSpinner.setLayoutData(textData);
		minimaleLinienabstandSpinner.addSelectionListener(new MinimalLinienabstandSelectionAdapter());

		minimaleLinienabstandUseDefault = factory.createButton(dynamischesZoomverhaltenGroup, "default", SWT.CHECK);
		textData = new FormData();
		textData.left = new FormAttachment(minimaleLinienabstandSpinner, HSPACE);
		textData.width = 70;
		textData.top = new FormAttachment(labelMinLinienabstand, 0, CENTER);
		minimaleLinienabstandUseDefault.setLayoutData(textData);
		minimaleLinienabstandUseDefault.addSelectionListener(new MinimalLinienabstandUseDefaultSelectionAdapter());

		final Label labelMaxLinienabstand = factory.createLabel(dynamischesZoomverhaltenGroup,
				"Maximaler Linienabstand:");
		labelData = new FormData();
		labelData.left = new FormAttachment(minimaleLinienabstandUseDefault, HSPACE);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(labelMinLinienabstand, 0, CENTER);
		labelMaxLinienabstand.setLayoutData(labelData);

		maximaleLinienabstandSpinner = new Spinner(dynamischesZoomverhaltenGroup, SWT.BORDER);
		maximaleLinienabstandSpinner.setValues(5000, 0, Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(maximaleLinienabstandSpinner);
		textData = new FormData();
		textData.left = new FormAttachment(labelMaxLinienabstand, HSPACE);
		textData.width = 150;
		textData.top = new FormAttachment(labelMaxLinienabstand, 0, CENTER);
		maximaleLinienabstandSpinner.setLayoutData(textData);
		maximaleLinienabstandSpinner.addSelectionListener(new MaximalLinienabstandSelectionAdapter());

		maximaleLinienabstandUseDefault = factory.createButton(dynamischesZoomverhaltenGroup, "default", SWT.CHECK);
		textData = new FormData();
		textData.left = new FormAttachment(maximaleLinienabstandSpinner, HSPACE);
		textData.width = 70;
		textData.top = new FormAttachment(labelMaxLinienabstand, 0, CENTER);
		maximaleLinienabstandUseDefault.setLayoutData(textData);
		maximaleLinienabstandUseDefault.addSelectionListener(new MaximalLinienabstandUseDefaultSelectionAdapter());
	}

	private void createStatischesZoomverhalten(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen

		statischesZoomverhaltenBtn = getWidgetFactory().createButton(parent,
				Zoomverhalten.STATISCHES_ZOOMVERHALTEN.getLiteral(), SWT.RADIO);
		statischesZoomverhaltenBtn.setSelection(true);

		FormData data = new FormData();
		data.left = new FormAttachment(0, HSPACE);
		data.top = new FormAttachment(parent, ITabbedPropertyConstants.VSPACE, SWT.BOTTOM);
		statischesZoomverhaltenBtn.setLayoutData(data);

		statischesZoomverhaltenGroup = getWidgetFactory().createGroup(parent, "");
		final FormLayout layout = new FormLayout();
		layout.marginWidth = ITabbedPropertyConstants.HSPACE + 2;
		layout.marginHeight = ITabbedPropertyConstants.VSPACE;
		layout.spacing = ITabbedPropertyConstants.VMARGIN + 1;
		statischesZoomverhaltenGroup.setLayout(layout);

		data = new FormData();
		data.left = new FormAttachment(0, HSPACE);
		data.right = new FormAttachment(100);
		data.top = new FormAttachment(statischesZoomverhaltenBtn, 0, SWT.TOP);
		statischesZoomverhaltenGroup.setLayoutData(data);

		linienabstandLabel = factory.createLabel(statischesZoomverhaltenGroup, "Linienabstand:");

		linienabstand = new Spinner(statischesZoomverhaltenGroup, BORDER);
		linienabstand.setMinimum(1);
		linienabstand.setMaximum(100);
		linienabstand.setIncrement(1);
		linienabstand.setPageIncrement(10);
		factory.adapt(parent);

		linienabstandUseDefault = factory.createButton(statischesZoomverhaltenGroup, "Defaultwert verwenden", CHECK);

		// Widgets layouten

		data = new FormData();
		data.left = new FormAttachment(linienabstandLabel, HSPACE);
		data.width = 150;
		data.top = new FormAttachment(statischesZoomverhaltenGroup, ITabbedPropertyConstants.VSPACE, SWT.TOP);
		linienabstand.setLayoutData(data);

		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(linienabstand, 0, CENTER);
		linienabstandLabel.setLayoutData(labelData);

		final FormData useDefaultData = new FormData();
		useDefaultData.left = new FormAttachment(linienabstand, 0, HSPACE);
		useDefaultData.top = new FormAttachment(linienabstand, 0, CENTER);
		linienabstandUseDefault.setLayoutData(useDefaultData);

		// Listener anmelden

		statischesZoomverhaltenBtn.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN,
						Zoomverhalten.STATISCHES_ZOOMVERHALTEN);
				getCommandStack().execute(cmd);
			}
		});

		linienabstand.addSelectionListener(new LinienabstandSelectionAdapter());
		linienabstandUseDefault.addSelectionListener(new LinienabstandUseDefaultSelectionAdapter());
	}

	@Override
	public void refresh() {
		setZoomverhaltenToWidget();
		setLinienabstandToWidget();
		disableLinienabstandIfNecessary();

		if (getElement().getLinienabstandMinimaleZoomstufe() != minimaleZoomstufeSpinner.getSelection()) {
			minimaleZoomstufeSpinner.setSelection(getElement().getLinienabstandMinimaleZoomstufe());
		}

		if (getElement().getLinienabstandMaximaleZoomstufe() != maximaleZoomstufeSpinner.getSelection()) {
			maximaleZoomstufeSpinner.setSelection(getElement().getLinienabstandMaximaleZoomstufe());
		}

		if (getElement().getLinienabstandMinimum() != minimaleLinienabstandSpinner.getSelection()) {
			minimaleLinienabstandSpinner.setSelection(getElement().getLinienabstandMinimum());
		}

		if (getElement().getLinienabstandMaximum() != maximaleLinienabstandSpinner.getSelection()) {
			maximaleLinienabstandSpinner.setSelection(getElement().getLinienabstandMaximum());
		}
		disableMinMaxZoomstufeIfNecessary();
		disableMinMaxLinienabstandIfNecessary();
	}

	private void setZoomverhaltenToWidget() {
		final Zoomverhalten zoomverhalten = getElement().getLinienabstandZoomverhalten();
		final boolean isChanged = dynamischesZoomverhaltenBtn.getSelection()
				&& zoomverhalten != Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN
				|| statischesZoomverhaltenBtn.getSelection() && zoomverhalten != Zoomverhalten.STATISCHES_ZOOMVERHALTEN;
		if (isChanged) {
			dynamischesZoomverhaltenBtn.setSelection(zoomverhalten == Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN);
			statischesZoomverhaltenBtn.setSelection(zoomverhalten == Zoomverhalten.STATISCHES_ZOOMVERHALTEN);
		}
	}

	private void setLinienabstandToWidget() {
		final boolean isChanged = linienabstand.getSelection() != getElement().getLinienabstand();
		if (isChanged) {
			linienabstand.setSelection(getElement().getLinienabstand());
		}
	}

	private void disableLinienabstandIfNecessary() {
		final boolean isDoKomponente = getElement().eContainer() instanceof DoKomponente;
		final boolean useDefault = !getElement().isSetLinienabstand();

		linienabstandUseDefault.setSelection(useDefault);

		final boolean enabled = !isDoKomponente && !useDefault;
		linienabstand.setEnabled(enabled);
		linienabstandLabel.setEnabled(enabled);
		linienabstandUseDefault.setEnabled(!isDoKomponente);
	}

	private void disableMinMaxZoomstufeIfNecessary() {
		final boolean isDoKomponente = getElement().eContainer() instanceof DoKomponente;
		final boolean useDefaultMinimaleZoomstufe = !getElement().isSetLinienabstandMinimaleZoomstufe();
		final boolean useDefaultMaximaleZoomstufe = !getElement().isSetLinienabstandMaximaleZoomstufe();

		minimaleZoomstufeUseDefault.setSelection(useDefaultMinimaleZoomstufe);
		maximaleZoomstufeUseDefault.setSelection(useDefaultMaximaleZoomstufe);

		final boolean enabledMinimaleZoomstufe = !isDoKomponente && !useDefaultMinimaleZoomstufe;
		minimaleZoomstufeSpinner.setEnabled(enabledMinimaleZoomstufe);
		minimaleZoomstufeUseDefault.setEnabled(!isDoKomponente);

		final boolean enabledMaximaleZoomstufe = !isDoKomponente && !useDefaultMaximaleZoomstufe;
		maximaleZoomstufeSpinner.setEnabled(enabledMaximaleZoomstufe);
		maximaleZoomstufeUseDefault.setEnabled(!isDoKomponente);
	}

	private void disableMinMaxLinienabstandIfNecessary() {
		final boolean isDoKomponente = getElement().eContainer() instanceof DoKomponente;
		final boolean useDefaultMinimaleLinienabstand = !getElement().isSetLinienabstandMinimum();
		final boolean useDefaultMaximaleLinienabstand = !getElement().isSetLinienabstandMaximum();

		minimaleLinienabstandUseDefault.setSelection(useDefaultMinimaleLinienabstand);
		maximaleLinienabstandUseDefault.setSelection(useDefaultMaximaleLinienabstand);

		final boolean enabledMinimaleLinienabstand = !isDoKomponente && !useDefaultMinimaleLinienabstand;
		minimaleLinienabstandSpinner.setEnabled(enabledMinimaleLinienabstand);
		minimaleLinienabstandUseDefault.setEnabled(!isDoKomponente);

		final boolean enabledMaximaleLinienabstand = !isDoKomponente && !useDefaultMaximaleLinienabstand;
		maximaleLinienabstandSpinner.setEnabled(enabledMaximaleLinienabstand);
		maximaleLinienabstandUseDefault.setEnabled(!isDoKomponente);
	}

}
