/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.VMARGIN;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.UnsetCommand;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

/**
 * PropertySection für {@link MinMaxZoomDecorator}.
 *
 * @author BitCtrl Systems GmbH, Ch. Hösel
 *
 */
public class MinMaxZoomPropertySection extends AbstractSection<MinMaxZoomDecorator> {

	private final class MaximalZoomstufeUseDefaultSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			if (maximaleZoomstufeUseDefault.getSelection()) {
				final UnsetCommand cmd = new UnsetCommand(getElement(),
						DobjDecoratorPackage.Literals.MIN_MAX_ZOOM_DECORATOR__MAXIMALE_ZOOMSTUFE);
				getCommandStack().execute(cmd);
			} else {
				final int value = getElement().getMaximaleZoomstufe();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.MIN_MAX_ZOOM_DECORATOR__MAXIMALE_ZOOMSTUFE, value);
				getCommandStack().execute(cmd);
			}
		}
	}

	private final class MaximalZoomstufeSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			final int wert = maximaleZoomstufeSpinner.getSelection();
			final SetCommand cmd = new SetCommand(getElement(),
					DobjDecoratorPackage.Literals.MIN_MAX_ZOOM_DECORATOR__MAXIMALE_ZOOMSTUFE, wert);
			getCommandStack().execute(cmd);

		}
	}

	private final class MinimalZoomstufeUseDefaultSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			if (minimaleZoomstufeUseDefault.getSelection()) {
				final UnsetCommand cmd = new UnsetCommand(getElement(),
						DobjDecoratorPackage.Literals.MIN_MAX_ZOOM_DECORATOR__MINIMALE_ZOOMSTUFE);
				getCommandStack().execute(cmd);
			} else {
				final int value = getElement().getMinimaleZoomstufe();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.MIN_MAX_ZOOM_DECORATOR__MINIMALE_ZOOMSTUFE, value);
				getCommandStack().execute(cmd);
			}
		}
	}

	private final class MinimalZoomstufeSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			final int wert = minimaleZoomstufeSpinner.getSelection();
			final SetCommand cmd = new SetCommand(getElement(),
					DobjDecoratorPackage.Literals.MIN_MAX_ZOOM_DECORATOR__MINIMALE_ZOOMSTUFE, wert);
			getCommandStack().execute(cmd);

		}
	}

	private Label labelMinZoomstufe;
	private Spinner minimaleZoomstufeSpinner;
	private Spinner maximaleZoomstufeSpinner;
	private Button minimaleZoomstufeUseDefault;
	private Button maximaleZoomstufeUseDefault;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createMinMaxPorperty(container);

	}

	private void createMinMaxPorperty(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen
		labelMinZoomstufe = factory.createLabel(parent, "Minimale Zoomstufe (in %):");
		FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(0, VMARGIN);
		labelMinZoomstufe.setLayoutData(labelData);

		minimaleZoomstufeSpinner = new Spinner(parent, SWT.BORDER);
		minimaleZoomstufeSpinner.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(minimaleZoomstufeSpinner);
		FormData textData = new FormData();
		textData.left = new FormAttachment(labelMinZoomstufe, HSPACE);
		textData.width = 150;
		textData.top = new FormAttachment(labelMinZoomstufe, 0, CENTER);
		minimaleZoomstufeSpinner.setLayoutData(textData);
		minimaleZoomstufeSpinner.addSelectionListener(new MinimalZoomstufeSelectionAdapter());

		minimaleZoomstufeUseDefault = factory.createButton(parent, "default", SWT.CHECK);
		textData = new FormData();
		textData.left = new FormAttachment(minimaleZoomstufeSpinner, HSPACE);
		textData.width = 70;
		textData.top = new FormAttachment(labelMinZoomstufe, 0, CENTER);
		minimaleZoomstufeUseDefault.setLayoutData(textData);

		minimaleZoomstufeUseDefault.addSelectionListener(new MinimalZoomstufeUseDefaultSelectionAdapter());

		final Label labelMaxZoomstufe = factory.createLabel(parent, "Maximale Zoomstufe (in %):");
		labelData = new FormData();
		labelData.left = new FormAttachment(minimaleZoomstufeUseDefault, HSPACE);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(0, VMARGIN);
		labelMaxZoomstufe.setLayoutData(labelData);

		maximaleZoomstufeSpinner = new Spinner(parent, SWT.BORDER);
		maximaleZoomstufeSpinner.setValues(5000, 0, Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(maximaleZoomstufeSpinner);
		textData = new FormData();
		textData.left = new FormAttachment(labelMaxZoomstufe, HSPACE);
		textData.width = 150;
		textData.top = new FormAttachment(maximaleZoomstufeSpinner, 0, CENTER);
		maximaleZoomstufeSpinner.setLayoutData(textData);
		maximaleZoomstufeSpinner.addSelectionListener(new MaximalZoomstufeSelectionAdapter());

		maximaleZoomstufeUseDefault = factory.createButton(parent, "default", SWT.CHECK);
		textData = new FormData();
		textData.left = new FormAttachment(maximaleZoomstufeSpinner, HSPACE);
		textData.width = 70;
		textData.top = new FormAttachment(labelMaxZoomstufe, 0, CENTER);
		maximaleZoomstufeUseDefault.setLayoutData(textData);
		maximaleZoomstufeUseDefault.addSelectionListener(new MaximalZoomstufeUseDefaultSelectionAdapter());

	}

	@Override
	public void refresh() {

		if (getElement().getMinimaleZoomstufe() != minimaleZoomstufeSpinner.getSelection()) {
			minimaleZoomstufeSpinner.setSelection(getElement().getMinimaleZoomstufe());
		}

		if (getElement().getMaximaleZoomstufe() != maximaleZoomstufeSpinner.getSelection()) {
			maximaleZoomstufeSpinner.setSelection(getElement().getMaximaleZoomstufe());
		}
		disableDrehungIfNecessary();
	}

	private void disableDrehungIfNecessary() {
		final boolean isDoKomponente = getElement().eContainer() instanceof DoKomponente;
		final boolean useDefaultMinimaleZoomstufe = !getElement().isSetMinimaleZoomstufe();
		final boolean useDefaultMaximaleZoomstufe = !getElement().isSetMaximaleZoomstufe();

		minimaleZoomstufeUseDefault.setSelection(useDefaultMinimaleZoomstufe);
		maximaleZoomstufeUseDefault.setSelection(useDefaultMaximaleZoomstufe);

		final boolean enabledMinimaleZoomstufe = !isDoKomponente && !useDefaultMinimaleZoomstufe;
		minimaleZoomstufeSpinner.setEnabled(enabledMinimaleZoomstufe);
		minimaleZoomstufeUseDefault.setEnabled(!isDoKomponente);

		final boolean enabledMaximaleZoomstufe = !isDoKomponente && !useDefaultMaximaleZoomstufe;
		maximaleZoomstufeSpinner.setEnabled(enabledMaximaleZoomstufe);
		maximaleZoomstufeUseDefault.setEnabled(!isDoKomponente);
	}
}
