/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.model;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * 
 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorFactory
 * @model kind="package"
 * @generated
 */
public interface DobjDecoratorPackage extends EPackage {
	/**
	 * The package name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNAME = "decorator";

	/**
	 * The package namespace URI. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNS_URI = "http://de.bsvrz.buv.plugin.dobj.decorator/1.0";

	/**
	 * The package namespace name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNS_PREFIX = "dobj.decorator";

	/**
	 * The singleton instance of the package. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	DobjDecoratorPackage eINSTANCE = de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl.init();

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator
	 * <em>Linienabstand Decorator</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getLinienabstandDecorator()
	 * @generated
	 */
	int LINIENABSTAND_DECORATOR = 0;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int LINIENABSTAND_DECORATOR__LINIENABSTAND = 0;

	/**
	 * The number of structural features of the '<em>Linienabstand
	 * Decorator</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENABSTAND_DECORATOR_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator
	 * <em>Skalierung Decorator</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getSkalierungDecorator()
	 * @generated
	 */
	int SKALIERUNG_DECORATOR = 1;

	/**
	 * The feature id for the '<em><b>Skalierungsfaktor</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SKALIERUNG_DECORATOR__SKALIERUNGSFAKTOR = 0;

	/**
	 * The number of structural features of the '<em>Skalierung Decorator</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SKALIERUNG_DECORATOR_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator
	 * <em>Drehung Decorator</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getDrehungDecorator()
	 * @generated
	 */
	int DREHUNG_DECORATOR = 2;

	/**
	 * The feature id for the '<em><b>Drehwinkel</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int DREHUNG_DECORATOR__DREHWINKEL = 0;

	/**
	 * The number of structural features of the '<em>Drehung Decorator</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHUNG_DECORATOR_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator
	 * <em>Datenstatus Decorator</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getDatenstatusDecorator()
	 * @generated
	 */
	int DATENSTATUS_DECORATOR = 3;

	/**
	 * The feature id for the '<em><b>Keine Quelle Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATENSTATUS_DECORATOR__KEINE_QUELLE_FARBE = 0;

	/**
	 * The feature id for the '<em><b>Keine Daten Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATENSTATUS_DECORATOR__KEINE_DATEN_FARBE = 1;

	/**
	 * The feature id for the '<em><b>Nutzdaten Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int DATENSTATUS_DECORATOR__NUTZDATEN_FARBE = 2;

	/**
	 * The number of structural features of the '<em>Datenstatus Decorator</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATENSTATUS_DECORATOR_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator
	 * <em>Linienstaerke Decorator</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getLinienstaerkeDecorator()
	 * @generated
	 */
	int LINIENSTAERKE_DECORATOR = 4;

	/**
	 * The feature id for the '<em><b>Linienstaerke</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int LINIENSTAERKE_DECORATOR__LINIENSTAERKE = 0;

	/**
	 * The number of structural features of the '<em>Linienstaerke
	 * Decorator</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENSTAERKE_DECORATOR_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator
	 * <em>Vordergrundfarbe Decorator</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getVordergrundfarbeDecorator()
	 * @generated
	 */
	int VORDERGRUNDFARBE_DECORATOR = 5;

	/**
	 * The feature id for the '<em><b>Vordergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int VORDERGRUNDFARBE_DECORATOR__VORDERGRUNDFARBE = 0;

	/**
	 * The number of structural features of the '<em>Vordergrundfarbe
	 * Decorator</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VORDERGRUNDFARBE_DECORATOR_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator
	 * <em>Hintergrundfarbe Decorator</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getHintergrundfarbeDecorator()
	 * @generated
	 */
	int HINTERGRUNDFARBE_DECORATOR = 6;

	/**
	 * The feature id for the '<em><b>Hintergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int HINTERGRUNDFARBE_DECORATOR__HINTERGRUNDFARBE = 0;

	/**
	 * The number of structural features of the '<em>Hintergrundfarbe
	 * Decorator</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int HINTERGRUNDFARBE_DECORATOR_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator
	 * <em>Schrift Decorator</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getSchriftDecorator()
	 * @generated
	 */
	int SCHRIFT_DECORATOR = 7;

	/**
	 * The feature id for the '<em><b>Schrift</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SCHRIFT_DECORATOR__SCHRIFT = 0;

	/**
	 * The number of structural features of the '<em>Schrift Decorator</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SCHRIFT_DECORATOR_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator
	 * <em>Stoerfall Indikator Decorator</em>}' class. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getStoerfallIndikatorDecorator()
	 * @generated
	 */
	int STOERFALL_INDIKATOR_DECORATOR = 8;

	/**
	 * The feature id for the '<em><b>Stoerung Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DECORATOR__STOERUNG_FARBE = 0;

	/**
	 * The feature id for the '<em><b>Keine Aussage Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DECORATOR__KEINE_AUSSAGE_FARBE = 1;

	/**
	 * The feature id for the '<em><b>Freier Verkehr Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DECORATOR__FREIER_VERKEHR_FARBE = 2;

	/**
	 * The feature id for the '<em><b>Lebhafter Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DECORATOR__LEBHAFTER_VERKEHR_FARBE = 3;

	/**
	 * The feature id for the '<em><b>Dichter Verkehr Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DECORATOR__DICHTER_VERKEHR_FARBE = 4;

	/**
	 * The feature id for the '<em><b>Zaehfliessender Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DECORATOR__ZAEHFLIESSENDER_VERKEHR_FARBE = 5;

	/**
	 * The feature id for the '<em><b>Stockender Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DECORATOR__STOCKENDER_VERKEHR_FARBE = 6;

	/**
	 * The feature id for the '<em><b>Stau Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DECORATOR__STAU_FARBE = 7;

	/**
	 * The number of structural features of the '<em>Stoerfall Indikator
	 * Decorator</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DECORATOR_FEATURE_COUNT = 8;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator
	 * <em>Antikollisionsalgorithmus Decorator</em>}' class. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getAntikollisionsalgorithmusDecorator()
	 * @generated
	 */
	int ANTIKOLLISIONSALGORITHMUS_DECORATOR = 9;

	/**
	 * The feature id for the '<em><b>Antikollisionsalgorithmus
	 * Anwenden</b></em>' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int ANTIKOLLISIONSALGORITHMUS_DECORATOR__ANTIKOLLISIONSALGORITHMUS_ANWENDEN = 0;

	/**
	 * The number of structural features of the '<em>Antikollisionsalgorithmus
	 * Decorator</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ANTIKOLLISIONSALGORITHMUS_DECORATOR_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.TransparenzDecorator
	 * <em>Transparenz Decorator</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.TransparenzDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getTransparenzDecorator()
	 * @generated
	 */
	int TRANSPARENZ_DECORATOR = 10;

	/**
	 * The feature id for the '<em><b>Transparenz</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TRANSPARENZ_DECORATOR__TRANSPARENZ = 0;

	/**
	 * The number of structural features of the '<em>Transparenz Decorator</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSPARENZ_DECORATOR_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyleDecorator
	 * <em>Linien Style Decorator</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyleDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getLinienStyleDecorator()
	 * @generated
	 */
	int LINIEN_STYLE_DECORATOR = 11;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int LINIEN_STYLE_DECORATOR__STYLE = 0;

	/**
	 * The number of structural features of the '<em>Linien Style
	 * Decorator</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIEN_STYLE_DECORATOR_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator
	 * <em>Zoom Verhalten Fix Decorator</em>}' class. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getZoomVerhaltenFixDecorator()
	 * @generated
	 */
	int ZOOM_VERHALTEN_FIX_DECORATOR = 12;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten Fix</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_FIX_DECORATOR__ZOOM_VERHALTEN_FIX = 0;

	/**
	 * The number of structural features of the '<em>Zoom Verhalten Fix
	 * Decorator</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_FIX_DECORATOR_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator
	 * <em>Min Max Zoom Decorator</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getMinMaxZoomDecorator()
	 * @generated
	 */
	int MIN_MAX_ZOOM_DECORATOR = 13;

	/**
	 * The feature id for the '<em><b>Minimale Zoomstufe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MIN_MAX_ZOOM_DECORATOR__MINIMALE_ZOOMSTUFE = 0;

	/**
	 * The feature id for the '<em><b>Maximale Zoomstufe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MIN_MAX_ZOOM_DECORATOR__MAXIMALE_ZOOMSTUFE = 1;

	/**
	 * The number of structural features of the '<em>Min Max Zoom
	 * Decorator</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MIN_MAX_ZOOM_DECORATOR_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator
	 * <em>Selektierbar Decorator</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getSelektierbarDecorator()
	 * @generated
	 */
	int SELEKTIERBAR_DECORATOR = 14;

	/**
	 * The feature id for the '<em><b>Selektierbar</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SELEKTIERBAR_DECORATOR__SELEKTIERBAR = 0;

	/**
	 * The number of structural features of the '<em>Selektierbar
	 * Decorator</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELEKTIERBAR_DECORATOR_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator
	 * <em>Groesse Decorator</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getGroesseDecorator()
	 * @generated
	 */
	int GROESSE_DECORATOR = 15;

	/**
	 * The feature id for the '<em><b>Groesse</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int GROESSE_DECORATOR__GROESSE = 0;

	/**
	 * The number of structural features of the '<em>Groesse Decorator</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GROESSE_DECORATOR_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienstaerkeZoomDecoratorImpl
	 * <em>Linienstaerke Zoom Decorator</em>}' class. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienstaerkeZoomDecoratorImpl
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getLinienstaerkeZoomDecorator()
	 * @generated
	 */
	int LINIENSTAERKE_ZOOM_DECORATOR = 16;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN = 0;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE = 1;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE = 2;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM = 3;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM = 4;

	/**
	 * The feature id for the '<em><b>Linienstaerke</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE = 5;

	/**
	 * The number of structural features of the '<em>Linienstaerke Zoom
	 * Decorator</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENSTAERKE_ZOOM_DECORATOR_FEATURE_COUNT = 6;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienabstandZoomDecoratorImpl
	 * <em>Linienabstand Zoom Decorator</em>}' class. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienabstandZoomDecoratorImpl
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getLinienabstandZoomDecorator()
	 * @generated
	 */
	int LINIENABSTAND_ZOOM_DECORATOR = 17;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN = 0;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE = 1;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = 2;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM = 3;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM = 4;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND = 5;

	/**
	 * The number of structural features of the '<em>Linienabstand Zoom
	 * Decorator</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIENABSTAND_ZOOM_DECORATOR_FEATURE_COUNT = 6;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyle <em>Linien
	 * Style</em>}' enum. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyle
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getLinienStyle()
	 * @generated
	 */
	int LINIEN_STYLE = 18;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten
	 * <em>Zoomverhalten</em>}' enum. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getZoomverhalten()
	 * @generated
	 */
	int ZOOMVERHALTEN = 19;

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator
	 * <em>Linienabstand Decorator</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Linienabstand Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator
	 * @generated
	 */
	EClass getLinienabstandDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator#getLinienabstand
	 * <em>Linienabstand</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienabstand</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator#getLinienabstand()
	 * @see #getLinienabstandDecorator()
	 * @generated
	 */
	EAttribute getLinienabstandDecorator_Linienabstand();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator
	 * <em>Skalierung Decorator</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Skalierung Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator
	 * @generated
	 */
	EClass getSkalierungDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator#getSkalierungsfaktor
	 * <em>Skalierungsfaktor</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for the attribute '<em>Skalierungsfaktor</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator#getSkalierungsfaktor()
	 * @see #getSkalierungDecorator()
	 * @generated
	 */
	EAttribute getSkalierungDecorator_Skalierungsfaktor();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator
	 * <em>Drehung Decorator</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for class '<em>Drehung Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator
	 * @generated
	 */
	EClass getDrehungDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator#getDrehwinkel
	 * <em>Drehwinkel</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Drehwinkel</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator#getDrehwinkel()
	 * @see #getDrehungDecorator()
	 * @generated
	 */
	EAttribute getDrehungDecorator_Drehwinkel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator
	 * <em>Datenstatus Decorator</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Datenstatus Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator
	 * @generated
	 */
	EClass getDatenstatusDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator#getKeineQuelleFarbe
	 * <em>Keine Quelle Farbe</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for the attribute '<em>Keine Quelle Farbe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator#getKeineQuelleFarbe()
	 * @see #getDatenstatusDecorator()
	 * @generated
	 */
	EAttribute getDatenstatusDecorator_KeineQuelleFarbe();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator#getKeineDatenFarbe
	 * <em>Keine Daten Farbe</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for the attribute '<em>Keine Daten Farbe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator#getKeineDatenFarbe()
	 * @see #getDatenstatusDecorator()
	 * @generated
	 */
	EAttribute getDatenstatusDecorator_KeineDatenFarbe();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator#getNutzdatenFarbe
	 * <em>Nutzdaten Farbe</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Nutzdaten Farbe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator#getNutzdatenFarbe()
	 * @see #getDatenstatusDecorator()
	 * @generated
	 */
	EAttribute getDatenstatusDecorator_NutzdatenFarbe();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator
	 * <em>Linienstaerke Decorator</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Linienstaerke Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator
	 * @generated
	 */
	EClass getLinienstaerkeDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator#getLinienstaerke
	 * <em>Linienstaerke</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator#getLinienstaerke()
	 * @see #getLinienstaerkeDecorator()
	 * @generated
	 */
	EAttribute getLinienstaerkeDecorator_Linienstaerke();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator
	 * <em>Vordergrundfarbe Decorator</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Vordergrundfarbe Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator
	 * @generated
	 */
	EClass getVordergrundfarbeDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator#getVordergrundfarbe
	 * <em>Vordergrundfarbe</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for the attribute '<em>Vordergrundfarbe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator#getVordergrundfarbe()
	 * @see #getVordergrundfarbeDecorator()
	 * @generated
	 */
	EAttribute getVordergrundfarbeDecorator_Vordergrundfarbe();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator
	 * <em>Hintergrundfarbe Decorator</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Hintergrundfarbe Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator
	 * @generated
	 */
	EClass getHintergrundfarbeDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator#getHintergrundfarbe
	 * <em>Hintergrundfarbe</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for the attribute '<em>Hintergrundfarbe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator#getHintergrundfarbe()
	 * @see #getHintergrundfarbeDecorator()
	 * @generated
	 */
	EAttribute getHintergrundfarbeDecorator_Hintergrundfarbe();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator
	 * <em>Schrift Decorator</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for class '<em>Schrift Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator
	 * @generated
	 */
	EClass getSchriftDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator#getSchrift
	 * <em>Schrift</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Schrift</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator#getSchrift()
	 * @see #getSchriftDecorator()
	 * @generated
	 */
	EAttribute getSchriftDecorator_Schrift();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator
	 * <em>Stoerfall Indikator Decorator</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Stoerfall Indikator
	 *         Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator
	 * @generated
	 */
	EClass getStoerfallIndikatorDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getStoerungFarbe
	 * <em>Stoerung Farbe</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Stoerung Farbe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getStoerungFarbe()
	 * @see #getStoerfallIndikatorDecorator()
	 * @generated
	 */
	EAttribute getStoerfallIndikatorDecorator_StoerungFarbe();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getKeineAussageFarbe
	 * <em>Keine Aussage Farbe</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for the attribute '<em>Keine Aussage Farbe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getKeineAussageFarbe()
	 * @see #getStoerfallIndikatorDecorator()
	 * @generated
	 */
	EAttribute getStoerfallIndikatorDecorator_KeineAussageFarbe();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getFreierVerkehrFarbe
	 * <em>Freier Verkehr Farbe</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Freier Verkehr
	 *         Farbe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getFreierVerkehrFarbe()
	 * @see #getStoerfallIndikatorDecorator()
	 * @generated
	 */
	EAttribute getStoerfallIndikatorDecorator_FreierVerkehrFarbe();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getLebhafterVerkehrFarbe
	 * <em>Lebhafter Verkehr Farbe</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Lebhafter Verkehr
	 *         Farbe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getLebhafterVerkehrFarbe()
	 * @see #getStoerfallIndikatorDecorator()
	 * @generated
	 */
	EAttribute getStoerfallIndikatorDecorator_LebhafterVerkehrFarbe();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getDichterVerkehrFarbe
	 * <em>Dichter Verkehr Farbe</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Dichter Verkehr
	 *         Farbe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getDichterVerkehrFarbe()
	 * @see #getStoerfallIndikatorDecorator()
	 * @generated
	 */
	EAttribute getStoerfallIndikatorDecorator_DichterVerkehrFarbe();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getZaehfliessenderVerkehrFarbe
	 * <em>Zaehfliessender Verkehr Farbe</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Zaehfliessender Verkehr
	 *         Farbe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getZaehfliessenderVerkehrFarbe()
	 * @see #getStoerfallIndikatorDecorator()
	 * @generated
	 */
	EAttribute getStoerfallIndikatorDecorator_ZaehfliessenderVerkehrFarbe();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getStockenderVerkehrFarbe
	 * <em>Stockender Verkehr Farbe</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Stockender Verkehr
	 *         Farbe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getStockenderVerkehrFarbe()
	 * @see #getStoerfallIndikatorDecorator()
	 * @generated
	 */
	EAttribute getStoerfallIndikatorDecorator_StockenderVerkehrFarbe();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getStauFarbe
	 * <em>Stau Farbe</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Stau Farbe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator#getStauFarbe()
	 * @see #getStoerfallIndikatorDecorator()
	 * @generated
	 */
	EAttribute getStoerfallIndikatorDecorator_StauFarbe();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator
	 * <em>Antikollisionsalgorithmus Decorator</em>}'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Antikollisionsalgorithmus
	 *         Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator
	 * @generated
	 */
	EClass getAntikollisionsalgorithmusDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator#isAntikollisionsalgorithmusAnwenden
	 * <em>Antikollisionsalgorithmus Anwenden</em>}'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Antikollisionsalgorithmus
	 *         Anwenden</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator#isAntikollisionsalgorithmusAnwenden()
	 * @see #getAntikollisionsalgorithmusDecorator()
	 * @generated
	 */
	EAttribute getAntikollisionsalgorithmusDecorator_AntikollisionsalgorithmusAnwenden();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.TransparenzDecorator
	 * <em>Transparenz Decorator</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Transparenz Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.TransparenzDecorator
	 * @generated
	 */
	EClass getTransparenzDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.TransparenzDecorator#getTransparenz
	 * <em>Transparenz</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Transparenz</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.TransparenzDecorator#getTransparenz()
	 * @see #getTransparenzDecorator()
	 * @generated
	 */
	EAttribute getTransparenzDecorator_Transparenz();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyleDecorator
	 * <em>Linien Style Decorator</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Linien Style Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyleDecorator
	 * @generated
	 */
	EClass getLinienStyleDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyleDecorator#getStyle
	 * <em>Style</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Style</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyleDecorator#getStyle()
	 * @see #getLinienStyleDecorator()
	 * @generated
	 */
	EAttribute getLinienStyleDecorator_Style();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator
	 * <em>Zoom Verhalten Fix Decorator</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Zoom Verhalten Fix
	 *         Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator
	 * @generated
	 */
	EClass getZoomVerhaltenFixDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator#isZoomVerhaltenFix
	 * <em>Zoom Verhalten Fix</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for the attribute '<em>Zoom Verhalten Fix</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator#isZoomVerhaltenFix()
	 * @see #getZoomVerhaltenFixDecorator()
	 * @generated
	 */
	EAttribute getZoomVerhaltenFixDecorator_ZoomVerhaltenFix();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator
	 * <em>Min Max Zoom Decorator</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Min Max Zoom Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator
	 * @generated
	 */
	EClass getMinMaxZoomDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator#getMinimaleZoomstufe
	 * <em>Minimale Zoomstufe</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for the attribute '<em>Minimale Zoomstufe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator#getMinimaleZoomstufe()
	 * @see #getMinMaxZoomDecorator()
	 * @generated
	 */
	EAttribute getMinMaxZoomDecorator_MinimaleZoomstufe();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator#getMaximaleZoomstufe
	 * <em>Maximale Zoomstufe</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for the attribute '<em>Maximale Zoomstufe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator#getMaximaleZoomstufe()
	 * @see #getMinMaxZoomDecorator()
	 * @generated
	 */
	EAttribute getMinMaxZoomDecorator_MaximaleZoomstufe();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator
	 * <em>Selektierbar Decorator</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Selektierbar Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator
	 * @generated
	 */
	EClass getSelektierbarDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator#isSelektierbar
	 * <em>Selektierbar</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Selektierbar</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator#isSelektierbar()
	 * @see #getSelektierbarDecorator()
	 * @generated
	 */
	EAttribute getSelektierbarDecorator_Selektierbar();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator
	 * <em>Groesse Decorator</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for class '<em>Groesse Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator
	 * @generated
	 */
	EClass getGroesseDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator#getGroesse
	 * <em>Groesse</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Groesse</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator#getGroesse()
	 * @see #getGroesseDecorator()
	 * @generated
	 */
	EAttribute getGroesseDecorator_Groesse();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator
	 * <em>Linienstaerke Zoom Decorator</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Linienstaerke Zoom
	 *         Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator
	 * @generated
	 */
	EClass getLinienstaerkeZoomDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator#getLinienstaerkeZoomverhalten
	 * <em>Linienstaerke Zoomverhalten</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke
	 *         Zoomverhalten</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator#getLinienstaerkeZoomverhalten()
	 * @see #getLinienstaerkeZoomDecorator()
	 * @generated
	 */
	EAttribute getLinienstaerkeZoomDecorator_LinienstaerkeZoomverhalten();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator#getLinienstaerkeMinimaleZoomstufe
	 * <em>Linienstaerke Minimale Zoomstufe</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke Minimale
	 *         Zoomstufe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator#getLinienstaerkeMinimaleZoomstufe()
	 * @see #getLinienstaerkeZoomDecorator()
	 * @generated
	 */
	EAttribute getLinienstaerkeZoomDecorator_LinienstaerkeMinimaleZoomstufe();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator#getLinienstaerkeMaximaleZoomstufe
	 * <em>Linienstaerke Maximale Zoomstufe</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke Maximale
	 *         Zoomstufe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator#getLinienstaerkeMaximaleZoomstufe()
	 * @see #getLinienstaerkeZoomDecorator()
	 * @generated
	 */
	EAttribute getLinienstaerkeZoomDecorator_LinienstaerkeMaximaleZoomstufe();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator#getLinienstaerkeMaximum
	 * <em>Linienstaerke Maximum</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke
	 *         Maximum</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator#getLinienstaerkeMaximum()
	 * @see #getLinienstaerkeZoomDecorator()
	 * @generated
	 */
	EAttribute getLinienstaerkeZoomDecorator_LinienstaerkeMaximum();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator#getLinienstaerkeMinimum
	 * <em>Linienstaerke Minimum</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke
	 *         Minimum</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator#getLinienstaerkeMinimum()
	 * @see #getLinienstaerkeZoomDecorator()
	 * @generated
	 */
	EAttribute getLinienstaerkeZoomDecorator_LinienstaerkeMinimum();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator#getLinienstaerke
	 * <em>Linienstaerke</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator#getLinienstaerke()
	 * @see #getLinienstaerkeZoomDecorator()
	 * @generated
	 */
	EAttribute getLinienstaerkeZoomDecorator_Linienstaerke();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator
	 * <em>Linienabstand Zoom Decorator</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Linienabstand Zoom
	 *         Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator
	 * @generated
	 */
	EClass getLinienabstandZoomDecorator();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator#getLinienabstandZoomverhalten
	 * <em>Linienabstand Zoomverhalten</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienabstand
	 *         Zoomverhalten</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator#getLinienabstandZoomverhalten()
	 * @see #getLinienabstandZoomDecorator()
	 * @generated
	 */
	EAttribute getLinienabstandZoomDecorator_LinienabstandZoomverhalten();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator#getLinienabstandMinimaleZoomstufe
	 * <em>Linienabstand Minimale Zoomstufe</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienabstand Minimale
	 *         Zoomstufe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator#getLinienabstandMinimaleZoomstufe()
	 * @see #getLinienabstandZoomDecorator()
	 * @generated
	 */
	EAttribute getLinienabstandZoomDecorator_LinienabstandMinimaleZoomstufe();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator#getLinienabstandMaximaleZoomstufe
	 * <em>Linienabstand Maximale Zoomstufe</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienabstand Maximale
	 *         Zoomstufe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator#getLinienabstandMaximaleZoomstufe()
	 * @see #getLinienabstandZoomDecorator()
	 * @generated
	 */
	EAttribute getLinienabstandZoomDecorator_LinienabstandMaximaleZoomstufe();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator#getLinienabstandMaximum
	 * <em>Linienabstand Maximum</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienabstand
	 *         Maximum</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator#getLinienabstandMaximum()
	 * @see #getLinienabstandZoomDecorator()
	 * @generated
	 */
	EAttribute getLinienabstandZoomDecorator_LinienabstandMaximum();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator#getLinienabstandMinimum
	 * <em>Linienabstand Minimum</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienabstand
	 *         Minimum</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator#getLinienabstandMinimum()
	 * @see #getLinienabstandZoomDecorator()
	 * @generated
	 */
	EAttribute getLinienabstandZoomDecorator_LinienabstandMinimum();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator#getLinienabstand
	 * <em>Linienabstand</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienabstand</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator#getLinienabstand()
	 * @see #getLinienabstandZoomDecorator()
	 * @generated
	 */
	EAttribute getLinienabstandZoomDecorator_Linienabstand();

	/**
	 * Returns the meta object for enum
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyle <em>Linien
	 * Style</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for enum '<em>Linien Style</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyle
	 * @generated
	 */
	EEnum getLinienStyle();

	/**
	 * Returns the meta object for enum
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten
	 * <em>Zoomverhalten</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for enum '<em>Zoomverhalten</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten
	 * @generated
	 */
	EEnum getZoomverhalten();

	/**
	 * Returns the factory that creates the instances of the model. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	DobjDecoratorFactory getDobjDecoratorFactory();

	/**
	 * <!-- begin-user-doc --> Defines literals for the meta objects that
	 * represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator
		 * <em>Linienabstand Decorator</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getLinienabstandDecorator()
		 * @generated
		 */
		EClass LINIENABSTAND_DECORATOR = eINSTANCE.getLinienabstandDecorator();

		/**
		 * The meta object literal for the '<em><b>Linienabstand</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIENABSTAND_DECORATOR__LINIENABSTAND = eINSTANCE.getLinienabstandDecorator_Linienabstand();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator
		 * <em>Skalierung Decorator</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getSkalierungDecorator()
		 * @generated
		 */
		EClass SKALIERUNG_DECORATOR = eINSTANCE.getSkalierungDecorator();

		/**
		 * The meta object literal for the '<em><b>Skalierungsfaktor</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute SKALIERUNG_DECORATOR__SKALIERUNGSFAKTOR = eINSTANCE.getSkalierungDecorator_Skalierungsfaktor();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator
		 * <em>Drehung Decorator</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getDrehungDecorator()
		 * @generated
		 */
		EClass DREHUNG_DECORATOR = eINSTANCE.getDrehungDecorator();

		/**
		 * The meta object literal for the '<em><b>Drehwinkel</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute DREHUNG_DECORATOR__DREHWINKEL = eINSTANCE.getDrehungDecorator_Drehwinkel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator
		 * <em>Datenstatus Decorator</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getDatenstatusDecorator()
		 * @generated
		 */
		EClass DATENSTATUS_DECORATOR = eINSTANCE.getDatenstatusDecorator();

		/**
		 * The meta object literal for the '<em><b>Keine Quelle Farbe</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute DATENSTATUS_DECORATOR__KEINE_QUELLE_FARBE = eINSTANCE.getDatenstatusDecorator_KeineQuelleFarbe();

		/**
		 * The meta object literal for the '<em><b>Keine Daten Farbe</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute DATENSTATUS_DECORATOR__KEINE_DATEN_FARBE = eINSTANCE.getDatenstatusDecorator_KeineDatenFarbe();

		/**
		 * The meta object literal for the '<em><b>Nutzdaten Farbe</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute DATENSTATUS_DECORATOR__NUTZDATEN_FARBE = eINSTANCE.getDatenstatusDecorator_NutzdatenFarbe();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator
		 * <em>Linienstaerke Decorator</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getLinienstaerkeDecorator()
		 * @generated
		 */
		EClass LINIENSTAERKE_DECORATOR = eINSTANCE.getLinienstaerkeDecorator();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIENSTAERKE_DECORATOR__LINIENSTAERKE = eINSTANCE.getLinienstaerkeDecorator_Linienstaerke();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator
		 * <em>Vordergrundfarbe Decorator</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getVordergrundfarbeDecorator()
		 * @generated
		 */
		EClass VORDERGRUNDFARBE_DECORATOR = eINSTANCE.getVordergrundfarbeDecorator();

		/**
		 * The meta object literal for the '<em><b>Vordergrundfarbe</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute VORDERGRUNDFARBE_DECORATOR__VORDERGRUNDFARBE = eINSTANCE
				.getVordergrundfarbeDecorator_Vordergrundfarbe();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator
		 * <em>Hintergrundfarbe Decorator</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getHintergrundfarbeDecorator()
		 * @generated
		 */
		EClass HINTERGRUNDFARBE_DECORATOR = eINSTANCE.getHintergrundfarbeDecorator();

		/**
		 * The meta object literal for the '<em><b>Hintergrundfarbe</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute HINTERGRUNDFARBE_DECORATOR__HINTERGRUNDFARBE = eINSTANCE
				.getHintergrundfarbeDecorator_Hintergrundfarbe();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator
		 * <em>Schrift Decorator</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getSchriftDecorator()
		 * @generated
		 */
		EClass SCHRIFT_DECORATOR = eINSTANCE.getSchriftDecorator();

		/**
		 * The meta object literal for the '<em><b>Schrift</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute SCHRIFT_DECORATOR__SCHRIFT = eINSTANCE.getSchriftDecorator_Schrift();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator
		 * <em>Stoerfall Indikator Decorator</em>}' class. <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getStoerfallIndikatorDecorator()
		 * @generated
		 */
		EClass STOERFALL_INDIKATOR_DECORATOR = eINSTANCE.getStoerfallIndikatorDecorator();

		/**
		 * The meta object literal for the '<em><b>Stoerung Farbe</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STOERFALL_INDIKATOR_DECORATOR__STOERUNG_FARBE = eINSTANCE
				.getStoerfallIndikatorDecorator_StoerungFarbe();

		/**
		 * The meta object literal for the '<em><b>Keine Aussage Farbe</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STOERFALL_INDIKATOR_DECORATOR__KEINE_AUSSAGE_FARBE = eINSTANCE
				.getStoerfallIndikatorDecorator_KeineAussageFarbe();

		/**
		 * The meta object literal for the '<em><b>Freier Verkehr
		 * Farbe</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STOERFALL_INDIKATOR_DECORATOR__FREIER_VERKEHR_FARBE = eINSTANCE
				.getStoerfallIndikatorDecorator_FreierVerkehrFarbe();

		/**
		 * The meta object literal for the '<em><b>Lebhafter Verkehr
		 * Farbe</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STOERFALL_INDIKATOR_DECORATOR__LEBHAFTER_VERKEHR_FARBE = eINSTANCE
				.getStoerfallIndikatorDecorator_LebhafterVerkehrFarbe();

		/**
		 * The meta object literal for the '<em><b>Dichter Verkehr
		 * Farbe</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STOERFALL_INDIKATOR_DECORATOR__DICHTER_VERKEHR_FARBE = eINSTANCE
				.getStoerfallIndikatorDecorator_DichterVerkehrFarbe();

		/**
		 * The meta object literal for the '<em><b>Zaehfliessender Verkehr
		 * Farbe</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STOERFALL_INDIKATOR_DECORATOR__ZAEHFLIESSENDER_VERKEHR_FARBE = eINSTANCE
				.getStoerfallIndikatorDecorator_ZaehfliessenderVerkehrFarbe();

		/**
		 * The meta object literal for the '<em><b>Stockender Verkehr
		 * Farbe</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STOERFALL_INDIKATOR_DECORATOR__STOCKENDER_VERKEHR_FARBE = eINSTANCE
				.getStoerfallIndikatorDecorator_StockenderVerkehrFarbe();

		/**
		 * The meta object literal for the '<em><b>Stau Farbe</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STOERFALL_INDIKATOR_DECORATOR__STAU_FARBE = eINSTANCE.getStoerfallIndikatorDecorator_StauFarbe();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator
		 * <em>Antikollisionsalgorithmus Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getAntikollisionsalgorithmusDecorator()
		 * @generated
		 */
		EClass ANTIKOLLISIONSALGORITHMUS_DECORATOR = eINSTANCE.getAntikollisionsalgorithmusDecorator();

		/**
		 * The meta object literal for the '<em><b>Antikollisionsalgorithmus
		 * Anwenden</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute ANTIKOLLISIONSALGORITHMUS_DECORATOR__ANTIKOLLISIONSALGORITHMUS_ANWENDEN = eINSTANCE
				.getAntikollisionsalgorithmusDecorator_AntikollisionsalgorithmusAnwenden();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.TransparenzDecorator
		 * <em>Transparenz Decorator</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.TransparenzDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getTransparenzDecorator()
		 * @generated
		 */
		EClass TRANSPARENZ_DECORATOR = eINSTANCE.getTransparenzDecorator();

		/**
		 * The meta object literal for the '<em><b>Transparenz</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute TRANSPARENZ_DECORATOR__TRANSPARENZ = eINSTANCE.getTransparenzDecorator_Transparenz();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyleDecorator
		 * <em>Linien Style Decorator</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyleDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getLinienStyleDecorator()
		 * @generated
		 */
		EClass LINIEN_STYLE_DECORATOR = eINSTANCE.getLinienStyleDecorator();

		/**
		 * The meta object literal for the '<em><b>Style</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIEN_STYLE_DECORATOR__STYLE = eINSTANCE.getLinienStyleDecorator_Style();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator
		 * <em>Zoom Verhalten Fix Decorator</em>}' class. <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getZoomVerhaltenFixDecorator()
		 * @generated
		 */
		EClass ZOOM_VERHALTEN_FIX_DECORATOR = eINSTANCE.getZoomVerhaltenFixDecorator();

		/**
		 * The meta object literal for the '<em><b>Zoom Verhalten Fix</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute ZOOM_VERHALTEN_FIX_DECORATOR__ZOOM_VERHALTEN_FIX = eINSTANCE
				.getZoomVerhaltenFixDecorator_ZoomVerhaltenFix();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator
		 * <em>Min Max Zoom Decorator</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getMinMaxZoomDecorator()
		 * @generated
		 */
		EClass MIN_MAX_ZOOM_DECORATOR = eINSTANCE.getMinMaxZoomDecorator();

		/**
		 * The meta object literal for the '<em><b>Minimale Zoomstufe</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute MIN_MAX_ZOOM_DECORATOR__MINIMALE_ZOOMSTUFE = eINSTANCE.getMinMaxZoomDecorator_MinimaleZoomstufe();

		/**
		 * The meta object literal for the '<em><b>Maximale Zoomstufe</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute MIN_MAX_ZOOM_DECORATOR__MAXIMALE_ZOOMSTUFE = eINSTANCE.getMinMaxZoomDecorator_MaximaleZoomstufe();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator
		 * <em>Selektierbar Decorator</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getSelektierbarDecorator()
		 * @generated
		 */
		EClass SELEKTIERBAR_DECORATOR = eINSTANCE.getSelektierbarDecorator();

		/**
		 * The meta object literal for the '<em><b>Selektierbar</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute SELEKTIERBAR_DECORATOR__SELEKTIERBAR = eINSTANCE.getSelektierbarDecorator_Selektierbar();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator
		 * <em>Groesse Decorator</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getGroesseDecorator()
		 * @generated
		 */
		EClass GROESSE_DECORATOR = eINSTANCE.getGroesseDecorator();

		/**
		 * The meta object literal for the '<em><b>Groesse</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute GROESSE_DECORATOR__GROESSE = eINSTANCE.getGroesseDecorator_Groesse();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienstaerkeZoomDecoratorImpl
		 * <em>Linienstaerke Zoom Decorator</em>}' class. <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienstaerkeZoomDecoratorImpl
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getLinienstaerkeZoomDecorator()
		 * @generated
		 */
		EClass LINIENSTAERKE_ZOOM_DECORATOR = eINSTANCE.getLinienstaerkeZoomDecorator();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke
		 * Zoomverhalten</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN = eINSTANCE
				.getLinienstaerkeZoomDecorator_LinienstaerkeZoomverhalten();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Minimale
		 * Zoomstufe</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE = eINSTANCE
				.getLinienstaerkeZoomDecorator_LinienstaerkeMinimaleZoomstufe();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Maximale
		 * Zoomstufe</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE = eINSTANCE
				.getLinienstaerkeZoomDecorator_LinienstaerkeMaximaleZoomstufe();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke
		 * Maximum</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM = eINSTANCE
				.getLinienstaerkeZoomDecorator_LinienstaerkeMaximum();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke
		 * Minimum</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM = eINSTANCE
				.getLinienstaerkeZoomDecorator_LinienstaerkeMinimum();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE = eINSTANCE
				.getLinienstaerkeZoomDecorator_Linienstaerke();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienabstandZoomDecoratorImpl
		 * <em>Linienabstand Zoom Decorator</em>}' class. <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienabstandZoomDecoratorImpl
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getLinienabstandZoomDecorator()
		 * @generated
		 */
		EClass LINIENABSTAND_ZOOM_DECORATOR = eINSTANCE.getLinienabstandZoomDecorator();

		/**
		 * The meta object literal for the '<em><b>Linienabstand
		 * Zoomverhalten</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN = eINSTANCE
				.getLinienabstandZoomDecorator_LinienabstandZoomverhalten();

		/**
		 * The meta object literal for the '<em><b>Linienabstand Minimale
		 * Zoomstufe</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE = eINSTANCE
				.getLinienabstandZoomDecorator_LinienabstandMinimaleZoomstufe();

		/**
		 * The meta object literal for the '<em><b>Linienabstand Maximale
		 * Zoomstufe</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = eINSTANCE
				.getLinienabstandZoomDecorator_LinienabstandMaximaleZoomstufe();

		/**
		 * The meta object literal for the '<em><b>Linienabstand
		 * Maximum</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM = eINSTANCE
				.getLinienabstandZoomDecorator_LinienabstandMaximum();

		/**
		 * The meta object literal for the '<em><b>Linienabstand
		 * Minimum</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM = eINSTANCE
				.getLinienabstandZoomDecorator_LinienabstandMinimum();

		/**
		 * The meta object literal for the '<em><b>Linienabstand</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND = eINSTANCE
				.getLinienabstandZoomDecorator_Linienabstand();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyle
		 * <em>Linien Style</em>}' enum. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyle
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getLinienStyle()
		 * @generated
		 */
		EEnum LINIEN_STYLE = eINSTANCE.getLinienStyle();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten
		 * <em>Zoomverhalten</em>}' enum. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten
		 * @see de.bsvrz.buv.plugin.dobj.decorator.model.impl.DobjDecoratorPackageImpl#getZoomverhalten()
		 * @generated
		 */
		EEnum ZOOMVERHALTEN = eINSTANCE.getZoomverhalten();

	}

} // DobjDecoratorPackage
