/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten;

/**
 * <!-- begin-user-doc --> An implementation of the model object
 * '<em><b>Linienabstand Zoom Decorator</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienabstandZoomDecoratorImpl#getLinienabstandZoomverhalten
 * <em>Linienabstand Zoomverhalten</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienabstandZoomDecoratorImpl#getLinienabstandMinimaleZoomstufe
 * <em>Linienabstand Minimale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienabstandZoomDecoratorImpl#getLinienabstandMaximaleZoomstufe
 * <em>Linienabstand Maximale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienabstandZoomDecoratorImpl#getLinienabstandMaximum
 * <em>Linienabstand Maximum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienabstandZoomDecoratorImpl#getLinienabstandMinimum
 * <em>Linienabstand Minimum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienabstandZoomDecoratorImpl#getLinienabstand
 * <em>Linienabstand</em>}</li>
 * </ul>
 *
 * @generated
 */
public class LinienabstandZoomDecoratorImpl extends EObjectImpl implements LinienabstandZoomDecorator {
	/**
	 * The default value of the '{@link #getLinienabstandZoomverhalten()
	 * <em>Linienabstand Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected static final Zoomverhalten LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT = Zoomverhalten.STATISCHES_ZOOMVERHALTEN;

	/**
	 * The cached value of the '{@link #getLinienabstandZoomverhalten()
	 * <em>Linienabstand Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected Zoomverhalten linienabstandZoomverhalten = LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT;

	/**
	 * The default value of the '{@link #getLinienabstandMinimaleZoomstufe()
	 * <em>Linienabstand Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinienabstandMinimaleZoomstufe()
	 * <em>Linienabstand Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMinimaleZoomstufe = LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT;

	/**
	 * This is true if the Linienabstand Minimale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMinimaleZoomstufeESet;

	/**
	 * The default value of the '{@link #getLinienabstandMaximaleZoomstufe()
	 * <em>Linienabstand Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT = 5000;

	/**
	 * The cached value of the '{@link #getLinienabstandMaximaleZoomstufe()
	 * <em>Linienabstand Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMaximaleZoomstufe = LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT;

	/**
	 * This is true if the Linienabstand Maximale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMaximaleZoomstufeESet;

	/**
	 * The default value of the '{@link #getLinienabstandMaximum()
	 * <em>Linienabstand Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMaximum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MAXIMUM_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienabstandMaximum()
	 * <em>Linienabstand Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMaximum()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMaximum = LINIENABSTAND_MAXIMUM_EDEFAULT;

	/**
	 * This is true if the Linienabstand Maximum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMaximumESet;

	/**
	 * The default value of the '{@link #getLinienabstandMinimum()
	 * <em>Linienabstand Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMinimum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MINIMUM_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienabstandMinimum()
	 * <em>Linienabstand Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMinimum()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMinimum = LINIENABSTAND_MINIMUM_EDEFAULT;

	/**
	 * This is true if the Linienabstand Minimum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMinimumESet;

	/**
	 * The default value of the '{@link #getLinienabstand()
	 * <em>Linienabstand</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstand()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienabstand()
	 * <em>Linienabstand</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstand()
	 * @generated
	 * @ordered
	 */
	protected int linienabstand = LINIENABSTAND_EDEFAULT;

	/**
	 * This is true if the Linienabstand attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandESet;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected LinienabstandZoomDecoratorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Zoomverhalten getLinienabstandZoomverhalten() {
		return linienabstandZoomverhalten;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandZoomverhalten(Zoomverhalten newLinienabstandZoomverhalten) {
		final Zoomverhalten oldLinienabstandZoomverhalten = linienabstandZoomverhalten;
		linienabstandZoomverhalten = newLinienabstandZoomverhalten == null ? LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT
				: newLinienabstandZoomverhalten;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN,
					oldLinienabstandZoomverhalten, linienabstandZoomverhalten));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMinimaleZoomstufe() {
		return linienabstandMinimaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMinimaleZoomstufe(int newLinienabstandMinimaleZoomstufe) {
		final int oldLinienabstandMinimaleZoomstufe = linienabstandMinimaleZoomstufe;
		linienabstandMinimaleZoomstufe = newLinienabstandMinimaleZoomstufe;
		final boolean oldLinienabstandMinimaleZoomstufeESet = linienabstandMinimaleZoomstufeESet;
		linienabstandMinimaleZoomstufeESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE,
					oldLinienabstandMinimaleZoomstufe, linienabstandMinimaleZoomstufe,
					!oldLinienabstandMinimaleZoomstufeESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMinimaleZoomstufe() {
		final int oldLinienabstandMinimaleZoomstufe = linienabstandMinimaleZoomstufe;
		final boolean oldLinienabstandMinimaleZoomstufeESet = linienabstandMinimaleZoomstufeESet;
		linienabstandMinimaleZoomstufe = LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT;
		linienabstandMinimaleZoomstufeESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE,
					oldLinienabstandMinimaleZoomstufe, LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienabstandMinimaleZoomstufeESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMinimaleZoomstufe() {
		return linienabstandMinimaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMaximaleZoomstufe() {
		return linienabstandMaximaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMaximaleZoomstufe(int newLinienabstandMaximaleZoomstufe) {
		final int oldLinienabstandMaximaleZoomstufe = linienabstandMaximaleZoomstufe;
		linienabstandMaximaleZoomstufe = newLinienabstandMaximaleZoomstufe;
		final boolean oldLinienabstandMaximaleZoomstufeESet = linienabstandMaximaleZoomstufeESet;
		linienabstandMaximaleZoomstufeESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE,
					oldLinienabstandMaximaleZoomstufe, linienabstandMaximaleZoomstufe,
					!oldLinienabstandMaximaleZoomstufeESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMaximaleZoomstufe() {
		final int oldLinienabstandMaximaleZoomstufe = linienabstandMaximaleZoomstufe;
		final boolean oldLinienabstandMaximaleZoomstufeESet = linienabstandMaximaleZoomstufeESet;
		linienabstandMaximaleZoomstufe = LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT;
		linienabstandMaximaleZoomstufeESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE,
					oldLinienabstandMaximaleZoomstufe, LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienabstandMaximaleZoomstufeESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMaximaleZoomstufe() {
		return linienabstandMaximaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMaximum() {
		return linienabstandMaximum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMaximum(int newLinienabstandMaximum) {
		final int oldLinienabstandMaximum = linienabstandMaximum;
		linienabstandMaximum = newLinienabstandMaximum;
		final boolean oldLinienabstandMaximumESet = linienabstandMaximumESet;
		linienabstandMaximumESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM, oldLinienabstandMaximum,
					linienabstandMaximum, !oldLinienabstandMaximumESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMaximum() {
		final int oldLinienabstandMaximum = linienabstandMaximum;
		final boolean oldLinienabstandMaximumESet = linienabstandMaximumESet;
		linienabstandMaximum = LINIENABSTAND_MAXIMUM_EDEFAULT;
		linienabstandMaximumESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM, oldLinienabstandMaximum,
					LINIENABSTAND_MAXIMUM_EDEFAULT, oldLinienabstandMaximumESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMaximum() {
		return linienabstandMaximumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMinimum() {
		return linienabstandMinimum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMinimum(int newLinienabstandMinimum) {
		final int oldLinienabstandMinimum = linienabstandMinimum;
		linienabstandMinimum = newLinienabstandMinimum;
		final boolean oldLinienabstandMinimumESet = linienabstandMinimumESet;
		linienabstandMinimumESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM, oldLinienabstandMinimum,
					linienabstandMinimum, !oldLinienabstandMinimumESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMinimum() {
		final int oldLinienabstandMinimum = linienabstandMinimum;
		final boolean oldLinienabstandMinimumESet = linienabstandMinimumESet;
		linienabstandMinimum = LINIENABSTAND_MINIMUM_EDEFAULT;
		linienabstandMinimumESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM, oldLinienabstandMinimum,
					LINIENABSTAND_MINIMUM_EDEFAULT, oldLinienabstandMinimumESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMinimum() {
		return linienabstandMinimumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstand() {
		return linienabstand;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstand(int newLinienabstand) {
		final int oldLinienabstand = linienabstand;
		linienabstand = newLinienabstand;
		final boolean oldLinienabstandESet = linienabstandESet;
		linienabstandESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND, oldLinienabstand, linienabstand,
					!oldLinienabstandESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstand() {
		final int oldLinienabstand = linienabstand;
		final boolean oldLinienabstandESet = linienabstandESet;
		linienabstand = LINIENABSTAND_EDEFAULT;
		linienabstandESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND, oldLinienabstand,
					LINIENABSTAND_EDEFAULT, oldLinienabstandESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstand() {
		return linienabstandESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN:
			return getLinienabstandZoomverhalten();
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			return getLinienabstandMinimaleZoomstufe();
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			return getLinienabstandMaximaleZoomstufe();
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM:
			return getLinienabstandMaximum();
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM:
			return getLinienabstandMinimum();
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND:
			return getLinienabstand();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN:
			setLinienabstandZoomverhalten((Zoomverhalten) newValue);
			return;
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			setLinienabstandMinimaleZoomstufe((Integer) newValue);
			return;
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			setLinienabstandMaximaleZoomstufe((Integer) newValue);
			return;
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM:
			setLinienabstandMaximum((Integer) newValue);
			return;
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM:
			setLinienabstandMinimum((Integer) newValue);
			return;
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND:
			setLinienabstand((Integer) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN:
			setLinienabstandZoomverhalten(LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT);
			return;
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			unsetLinienabstandMinimaleZoomstufe();
			return;
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			unsetLinienabstandMaximaleZoomstufe();
			return;
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM:
			unsetLinienabstandMaximum();
			return;
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM:
			unsetLinienabstandMinimum();
			return;
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND:
			unsetLinienabstand();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN:
			return linienabstandZoomverhalten != LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT;
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			return isSetLinienabstandMinimaleZoomstufe();
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			return isSetLinienabstandMaximaleZoomstufe();
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM:
			return isSetLinienabstandMaximum();
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM:
			return isSetLinienabstandMinimum();
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND:
			return isSetLinienabstand();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		final StringBuilder result = new StringBuilder(super.toString());
		result.append(" (linienabstandZoomverhalten: ");
		result.append(linienabstandZoomverhalten);
		result.append(", linienabstandMinimaleZoomstufe: ");
		if (linienabstandMinimaleZoomstufeESet)
			result.append(linienabstandMinimaleZoomstufe);
		else
			result.append("<unset>");
		result.append(", linienabstandMaximaleZoomstufe: ");
		if (linienabstandMaximaleZoomstufeESet)
			result.append(linienabstandMaximaleZoomstufe);
		else
			result.append("<unset>");
		result.append(", linienabstandMaximum: ");
		if (linienabstandMaximumESet)
			result.append(linienabstandMaximum);
		else
			result.append("<unset>");
		result.append(", linienabstandMinimum: ");
		if (linienabstandMinimumESet)
			result.append(linienabstandMinimum);
		else
			result.append("<unset>");
		result.append(", linienabstand: ");
		if (linienabstandESet)
			result.append(linienabstand);
		else
			result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} // LinienabstandZoomDecoratorImpl
