/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.Tool;
import org.eclipse.swt.SWT;

/**
 * Linienartige Feedback Figure für {@link Tool}s.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class LineFeedbackFigure extends Shape {

	private Point start;
	private Point end;

	{
		setLineStyle(SWT.LINE_DASH);
	}

	/**
	 * Gibt den Startpunkt der Linie zurück.
	 *
	 * @return der Startpunkt der Linie.
	 */
	public Point getStart() {
		return start;
	}

	/**
	 * Legt den Startpunkt der Linie fest.
	 *
	 * @param start
	 *            der Startpunkt der Linie.
	 */
	public void setStart(final Point start) {
		this.start = start;
	}

	/**
	 * Gibt den Endpunkt der Linie zurück.
	 *
	 * @return der Endpunkt der Linie.
	 */
	public Point getEnd() {
		return end;
	}

	/**
	 * Legt den Endpunkt der Linie fest.
	 *
	 * @param end
	 *            der Endpunkt der Linie.
	 */
	public void setEnd(final Point end) {
		this.end = end;
	}

	@Override
	protected void fillShape(final Graphics graphics) {
		// tut nix
	}

	@Override
	protected void outlineShape(final Graphics graphics) {
		graphics.drawLine(start, end);
	}

}
