/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * Das Plug-in <em>Darstellungsobjekte</em>.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
public class DObjPlugin extends AbstractUIPlugin {

	/** Die ID des Plugins. */
	public static final String PLUGIN_ID = "de.bsvrz.buv.plugin.dobj";

	/** Die globale Plugin-Instanz. */
	private static DObjPlugin plugin;

	/**
	 * Liefert die globale Instanz des Plugins.
	 *
	 * @return die Instanz
	 */
	public static DObjPlugin getDefault() {
		return DObjPlugin.plugin;
	}

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		DObjPlugin.plugin = this;
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		DObjPlugin.plugin = null;
		super.stop(context);
	}

	/**
	 * Sucht in diesem Plug-in nach einem Bild und gibt dessen Descriptor
	 * zurück.
	 *
	 * @param imageFilePath
	 *            der relative Pfad im Plug-in zum gesuchten Bild.
	 * @return der Descriptor zum Bild oder <code>null</code>, wenn das Bild
	 *         nicht gefunden werden konnte.
	 */
	public ImageDescriptor getImageDescriptor(final String imageFilePath) {
		return imageDescriptorFromPlugin(getBundle().getSymbolicName(), imageFilePath);
	}
}
