/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.internal;

import org.eclipse.osgi.util.NLS;

/**
 * Enthält die Übersetzungen des Plug-ins <em>Darstellungsobjekte</em>.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public final class DobjMessages extends NLS {

	/** Label für das Handwerkzeug zum Verschieben des anzeigten Ausschnitts. */
	public static String panLabel;

	/**
	 * Tooltip für das Handwerkzeug zum Verschieben des anzeigten Ausschnitts.
	 */
	public static String panTooltip;

	/** Label für das Hineinzoomen in einen Ausschnitts. */
	public static String rectangleZoomLabel;

	/** Tooltip für das Hineinzoomen in einen Ausschnitts. */
	public static String rectangleZoomTooltip;

	/** Label für die Aktion zum Online-/Offlineschalten einer Darstellung. */
	public static String toggleOnlineLabel;

	/** Tooltip für die Aktion zum Online-/Offlineschalten einer Darstellung. */
	public static String toggleOnlineTooltip;

	/** Label für das Tool Streckenselektion. */
	public static String streckeSelectionLabel;

	/** Tooltip für das Tool Streckenselektion. */
	public static String streckeSelectionTooltip;

	/** Label für das Tool Rechteckselektion. */
	public static String rectangleSelectionLabel;

	/** Tooltip für das Tool Rechteckselektion. */
	public static String rectangleSelectionTooltip;

	/** Label für das Tool Ellipsenselektion. */
	public static String ellipseSelectionLabel;

	/** Tooltip für das Tool Ellipsenselektion. */
	public static String ellipseSelectionTooltip;

	/** Label zur Beibehalteung des Ausschnitts. */
	public static String toggleFixViewportLabel;

	/** Tooltip zur Beibehalteung des Ausschnitts. */
	public static String toggleFixViewportTooltip;

	/** Label für die Action zum Ein-/Ausschalten der Teilselektion. */
	public static String toggleTouchedSelectionLabel;

	/** Tooltip für die Action zum Ein-/Ausschalten der Teilselektion. */
	public static String toggleTouchedSelectionTooltip;

	/**
	 * Label für die Action zum Ein-/Ausschalten des sofortigen
	 * Selektionsfeedbacks.
	 */
	public static String toggleSelectionFeedbackLabel;

	/**
	 * Tooltip für die Action zum Ein-/Ausschalten des sofortigen
	 * Selektionsfeedbacks.
	 */
	public static String toggleSelectionFeedbackTooltip;

	/**
	 * Label für die Aktion zum Ein-/Ausblenden der Verbindungsinien zwischen
	 * einem verschobenen Objekt und seiner Originalposition.
	 */
	public static String toggleVerbindungslinieLabel;

	/**
	 * Label fuer die Aktion zum Ein-/Ausblenden des Filters fuer <b>alle</b>
	 * gueltige Baustellen.
	 */
	public static String toggleBaustelleGueltigLabel;

	/**
	 * Tooltip für die Aktion zum Ein-/Ausblenden der Verbindungsinien zwischen
	 * einem verschobenen Objekt und seiner Originalposition.
	 */
	public static String toggleVerbindungslinieTooltip;

	/**
	 * Tooltip fuer die Aktion zum Ein-/Ausblenden des Filters fuer <b>alle</b>
	 * gueltige Baustellen.
	 */
	public static String toggleBaustelleGueltigTooltip;

	public static String toggleAntiKollisionsAlgorithmusLabel;

	public static String toggleAntiKollisionsAlgorithmusTooltip;

	static {
		NLS.initializeMessages("de.bsvrz.buv.plugin.dobj.internal.messages", DobjMessages.class);
	}

}
