/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.kollision;

import org.eclipse.draw2d.geometry.Point;

/**
 * Schnittstelle zu einer Ueberdeckungsfunktion fuer eine Objektkombination.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 *
 */
public interface IUeberdeckungsFunktion {

	/**
	 * Wenigstens eines der beiden Objekte ist zu hundert Prozent von dem
	 * anderen ueberdeckt.
	 */
	double VOLLSTAENDIGE_UEBERDECKUNG = 1.0;

	/**
	 * Die Objekte ueberschneiden sich in keinem Punkt.
	 */
	double KEINE_UEBERDECKUNG = 0.0;

	/**
	 * Errechnet den sog. Ueberdeckungskoeffizienten fuer die Objektkombination
	 * <code>o1</code> bzgl. <code>o2</code> bzw. umgedreht.<br>
	 * Dabei wird davon ausgegangen, dass <code>o1</code> sich am Ort
	 * <code>o1Ort</code> befindet (und nicht an dem Ort, der innerhalb des
	 * Objekts steht). Der Koeffizient gibt im Intervall [0, 1] an, wie stark
	 * sich die beiden Objekte ueberdecken. Dabei spielt es keine Rolle, welches
	 * Objekt im Fordergrund liegt. Die 0 entspricht dabei der Situation, dass
	 * sich die Objekte nicht ueberschneiden. Die 1 entspricht der Situation,
	 * dass wenigstens eines der beiden Objekte zu hundert Prozent von dem
	 * anderen ueberdeckt wird.
	 *
	 * @param o1Ort
	 *            der Ort, an den O1 alternativ verschoben ist.
	 * @param o1
	 *            Objekt 1.
	 * @param o2
	 *            Objekt 2.
	 * @return der Ueberdeckungskoeffizient von <code>o1</code> bzgl.
	 *         <code>o2</code> bzw. umgedreht.
	 */
	double getUeberdeckungsKoeffizient(Point o1Ort, final Object o1, final Object o2);

}
