/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.kollision;

import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;

/**
 * TODO: Erweiterbar machen!
 *
 * @author BitCtrl Systems GmbH, thierfelder
 */
final class UeberdeckungsFunktionsProvider {

	private UeberdeckungsFunktionsProvider() {
		// es gibt keine Instanzen der Klasse
	}

	/**
	 * Stellt eine Ueberdeckungsfunktion fuer die Objektkombination
	 * <code>(o1, o2)</code> zur Verfuegung.
	 *
	 * @param o1
	 *            Objekt 1.
	 * @param o2
	 *            Objekt 2.
	 * @return eine Ueberdeckungsfunktion fuer die Objektkombination
	 *         <code>(o1, o2)</code>. Nie <code>null</code>.
	 */
	static IUeberdeckungsFunktion getUeberdeckungsFunktionFuer(final Object o1, final Object o2) {
		final IArrangierbaresObjektMitExtraBounds a1 = Platform.getAdapterManager().getAdapter(o1,
				IArrangierbaresObjektMitExtraBounds.class);
		final IArrangierbaresObjektMitExtraBounds a2 = Platform.getAdapterManager().getAdapter(o2,
				IArrangierbaresObjektMitExtraBounds.class);
		if (a1 != null && a2 != null) {
			return UeberdeckungsFunktionFuerExtraBounds.INSTANZ;
		}

		final IFigure f1 = Platform.getAdapterManager().getAdapter(o1, IFigure.class);
		final IFigure f2 = Platform.getAdapterManager().getAdapter(o2, IFigure.class);
		if (f1 != null && f2 != null) {
			return StandardUeberdeckungsFunktion.INSTANZ;
		}

		return NullFunktion.INSTANZ;
	}

}
