/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.kollision.travers;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;

/**
 * Traversiert eine Menge von Punkten, die auf einem gleichschenkligen Dreieck
 * liegen.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 *
 */
public class GleichschenkligesDreieckTraverser extends PunktTraverser {

	/**
	 * Standardkonstruktor.
	 *
	 * @param mittelPunkt
	 *            der Mittelpunkt des Quadrats, das das Dreieck umschliesst.
	 * @param grundSeitenLaenge
	 *            die Grundseitenlaenge des Quadrats, das das Dreieck
	 *            umschliesst.
	 * @param anzahlPunkteSoll
	 *            Anzahl der Punkte, die hoechstens traversiert werden sollen.
	 */
	public GleichschenkligesDreieckTraverser(final Point mittelPunkt, final double grundSeitenLaenge,
			final int anzahlPunkteSoll) {
		super(mittelPunkt);
		final double radius = grundSeitenLaenge / 2.0;
		final double schritt = grundSeitenLaenge
				/ Math.sqrt(2.0 * Math.min(anzahlPunkteSoll, grundSeitenLaenge * radius));
		final double plus = schritt / 2;
		double inset = 0;
		for (double y = mittelPunkt.preciseY() + radius; y > mittelPunkt.preciseY() - radius; y -= schritt) {
			inset += plus;
			for (double x = mittelPunkt.preciseX() - radius + inset; x < mittelPunkt.preciseX() + radius
					- inset; x += schritt) {
				punktListe.add(new PrecisionPoint(x, y));
			}
		}
	}

}
