/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.kollision.travers;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;

import de.bsvrz.buv.plugin.dobj.vektor.Vektor2D;

/**
 * Sucht ein Quadrat ueber einem Mittelpunkt einer Linie ab. Begonnen wird dabei
 * mit dem Mittelpunkt der Grundlinie und von diesem aus gesehen wird sich von
 * unten nach oben abwechselnd von links nach rechts bewegt.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 *
 */
public class QuadratUeberPunktAbsucher extends PunktTraverser {

	/**
	 * Standardkonstruktor.
	 *
	 * @param startMittelPunkt
	 *            Mittelpunkt der Grundlinie des Quadrats auf dem Gesucht werden
	 *            soll.
	 * @param normierterNormalenVektor
	 *            normierter Normalenvektor im Mittelpunkt der Grundlinie.
	 * @param seitenLaenge
	 *            Seitenlaenge des Quadrats.
	 * @param anzahlPunkteSoll
	 *            Anzahl der Punkte, die innerhalb des Quadrats besucht werden
	 *            sollen.
	 */
	public QuadratUeberPunktAbsucher(final Point startMittelPunkt, final Vektor2D normierterNormalenVektor,
			final double seitenLaenge, final int anzahlPunkteSoll) {
		super(startMittelPunkt);
		final double radius = seitenLaenge / 2.0;
		final double step = seitenLaenge / Math.sqrt(Math.min(anzahlPunkteSoll, seitenLaenge * seitenLaenge));

		final Vektor2D antennaLinks = normierterNormalenVektor.getNormalenVektorLinks();
		final Vektor2D antennaRechts = normierterNormalenVektor.getNormalenVektorRechts();
		for (double laengeSenkrechte = 0; laengeSenkrechte < seitenLaenge; laengeSenkrechte += step) {
			for (double laengeWaagerechte = 0; laengeWaagerechte < radius; laengeWaagerechte += step) {
				punktListe.add(new PrecisionPoint(
						startMittelPunkt.x + laengeSenkrechte * normierterNormalenVektor.x
								+ antennaLinks.x * laengeWaagerechte,
						startMittelPunkt.y + laengeSenkrechte * normierterNormalenVektor.y
								+ antennaLinks.y * laengeWaagerechte));
				punktListe.add(new PrecisionPoint(
						startMittelPunkt.x + laengeSenkrechte * normierterNormalenVektor.x
								+ antennaRechts.x * laengeWaagerechte,
						startMittelPunkt.y + laengeSenkrechte * normierterNormalenVektor.y
								+ antennaRechts.y * laengeWaagerechte));
			}
		}
	}
}
